<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\models\User */

$this->title = 'Редактировать профиль';
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>
        <?= Html::a('← Назад в профиль', ['user/profile'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>

    <!-- Основной блок формы -->
    <div class="bg-white rounded-xl shadow-md p-6 max-w-2xl">
        <?php $form = ActiveForm::begin([
            'id' => 'profile-edit-form',
            'options' => ['class' => 'space-y-6']
        ]); ?>

        <!-- Сетка полей в 2 колонки на больших экранах -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Имя -->
            <?= $form->field($model, 'name', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Введите имя'
                ]
            ])->label('Имя *') ?>

            <!-- Фамилия -->
            <?= $form->field($model, 'surname', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Введите фамилию'
                ]
            ])->label('Фамилия *') ?>

            <!-- Отчество -->
            <?= $form->field($model, 'patronymic', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Введите отчество (при наличии)'
                ]
            ])->label('Отчество') ?>

            <!-- Логин -->
            <?= $form->field($model, 'login', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Введите логин'
                ]
            ])->label('Логин *') ?>

            <!-- Email -->
            <?= $form->field($model, 'email', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'example@email.com'
                ]
            ])->input('email')->label('Email *') ?>

            <!-- Телефон (если есть в модели) -->
            <?php if ($model->hasAttribute('phone')): ?>
                <?= $form->field($model, 'phone', [
                    'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                    'inputOptions' => [
                        'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                        'placeholder' => '+7 (999) 123-45-67'
                    ]
                ])->label('Телефон') ?>
            <?php endif; ?>
        </div>

        <!-- Дополнительные поля (полная ширина) -->
        <?php if ($model->hasAttribute('about')): ?>
            <div class="pt-2">
                <?= $form->field($model, 'about', [
                    'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                    'inputOptions' => [
                        'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                        'placeholder' => 'Расскажите о себе...',
                        'rows' => 4
                    ]
                ])->textarea()->label('О себе') ?>
            </div>
        <?php endif; ?>

        <!-- Загрузка аватара (если есть) -->
        <?php if ($model->hasAttribute('avatar')): ?>
            <div class="pt-2">
                <label class="block text-sm font-medium text-gray-700 mb-1">Аватар</label>
                <div class="flex items-center space-x-4">
                    <?php if ($model->avatar): ?>
                        <div class="w-16 h-16 rounded-full overflow-hidden bg-gray-200">
                            <img src="<?= Yii::$app->request->baseUrl . '/uploads/avatars/' . $model->avatar ?>"
                                 alt="Аватар" class="w-full h-full object-cover">
                        </div>
                    <?php else: ?>
                        <div class="w-16 h-16 rounded-full bg-blue-100 flex items-center justify-center">
                            <span class="text-2xl text-blue-600">👤</span>
                        </div>
                    <?php endif; ?>
                    <div class="flex-1">
                        <input type="file" name="avatar" class="w-full text-sm text-gray-500
                        file:mr-4 file:py-2 file:px-4
                        file:rounded-lg file:border-0
                        file:text-sm file:font-medium
                        file:bg-blue-50 file:text-blue-700
                        hover:file:bg-blue-100">
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Кнопки в стиле дизайн-проекта -->
        <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
            <?= Html::submitButton('Сохранить изменения', [
                'class' => 'flex-1 bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium'
            ]) ?>

            <?= Html::a('Отмена', ['user/profile'], [
                'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 transition-colors text-center'
            ]) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>



    <!-- Если есть ошибки валидации -->
<?php if ($model->hasErrors()): ?>
    <div class="mt-4 max-w-2xl">
        <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-700">
                        Пожалуйста, исправьте ошибки в форме.
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>