<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>

<!-- Контейнер в точном стиле дизайн-проекта -->
<div class="max-w-md mx-auto bg-white rounded-xl shadow-md p-8 mt-8">
    <!-- Заголовок как в дизайн-проекте -->
    <h2 class="text-3xl font-bold text-gray-800 mb-6 text-center">Регистрация</h2>

    <?php $form = ActiveForm::begin([
        'id' => 'register-form',
        'options' => ['class' => 'space-y-4']
    ]); ?>

    <!-- Поля в точном стиле дизайн-проекта -->

    <!-- Фамилия -->
    <?= $form->field($model, 'surname', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Введите фамилию'
        ]
    ])->label('Фамилия *') ?>

    <!-- Имя -->
    <?= $form->field($model, 'name', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Введите имя'
        ]
    ])->label('Имя *') ?>

    <!-- Отчество (если обязательно, добавьте * в label) -->
    <?= $form->field($model, 'patronymic', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Введите отчество (при наличии)'
        ]
    ])->label('Отчество') ?>

    <!-- Логин -->
    <?= $form->field($model, 'login', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Придумайте логин'
        ]
    ])->label('Логин *') ?>

    <!-- Email -->
    <?= $form->field($model, 'email', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'example@email.com'
        ]
    ])->input('email')->label('Email *') ?>

    <!-- Пароль -->
    <?= $form->field($model, 'password', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Придумайте пароль'
        ]
    ])->passwordInput()->label('Пароль *') ?>

    <!-- Повтор пароля -->
    <?= $form->field($model, 'password_repeat', [
        'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
        'inputOptions' => [
            'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
            'placeholder' => 'Повторите пароль'
        ]
    ])->passwordInput()->label('Повторите пароль *') ?>

    <!-- Чекбокс согласия с правилами -->
    <div class="flex items-center pt-2">
        <?= $form->field($model, 'rules', [
            'template' => '<div class="flex items-center">{input} {label}{error}</div>',
            'options' => ['class' => 'mb-0']
        ])->checkbox([
            'class' => 'w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500',
            'uncheck' => null
        ], false)->label('Согласен с правилами регистрации *', [
            'class' => 'ml-2 text-sm text-gray-700'
        ]) ?>
    </div>

    <!-- Кнопки в точном стиле дизайн-проекта -->
    <div class="mt-6 flex space-x-4">
        <?= Html::submitButton('Зарегистрироваться', [
            'class' => 'flex-1 bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition-colors font-medium'
        ]) ?>

        <?= Html::a('Отмена', ['site/index'], [
            'class' => 'flex-1 border border-gray-300 text-gray-700 py-2 rounded-lg hover:bg-gray-50 transition-colors text-center'
        ]) ?>
    </div>

    <!-- Ссылка на вход -->
    <div class="mt-6 pt-6 border-t border-gray-200 text-center">
        <p class="text-gray-600">
            Уже есть аккаунт?
            <?= Html::a('Войти в систему', ['site/login'], [
                'class' => 'text-blue-600 hover:text-blue-800 font-medium'
            ]) ?>
        </p>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<!-- Если нужно показать ошибки валидации сверху -->
<?php if ($model->hasErrors()): ?>
    <div class="max-w-md mx-auto mt-4">
        <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-red-700">
                        Пожалуйста, проверьте введённые данные.
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Дополнительно: можно добавить валидацию паролей через JS -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('register-form');
        const password = document.querySelector('[name*="password"]');
        const passwordRepeat = document.querySelector('[name*="password_repeat"]');

        if (form && password && passwordRepeat) {
            form.addEventListener('submit', function(e) {
                if (password.value !== passwordRepeat.value) {
                    e.preventDefault();
                    alert('Пароли не совпадают!');
                    passwordRepeat.focus();
                }
            });
        }
    });
</script>