<?php
use yii\helpers\Url;
use yii\helpers\Html;
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Активные конкурсы</h2>
    <!-- Здесь в будущем можно добавить кнопки фильтрации/сортировки -->
</div>

<!-- Если конкурсов нет -->
<?php if (empty($contests)): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <p class="text-gray-500 text-lg">Активных конкурсов пока нет.</p>
        <p class="text-gray-400 mt-2">Скоро здесь появятся новые конкурсы для участия</p>
    </div>
<?php endif; ?>

<!-- Сетка конкурсов в стиле дизайн-проекта -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <?php foreach ($contests as $contest): ?>
        <div class="bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transition-shadow">
            <!-- Изображение конкурса -->
            <?php if ($contest->image): ?>
                <img src="<?= Yii::$app->request->baseUrl . '/uploads/contests/' . Html::encode($contest->image) ?>"
                     class="w-full h-48 object-cover"
                     alt="<?= Html::encode($contest->title) ?>">
            <?php else: ?>
                <!-- Заглушка если нет изображения -->
                <div class="w-full h-48 bg-gradient-to-r from-blue-50 to-gray-100 flex items-center justify-center">
                    <span class="text-gray-400 text-lg">🌟 Конкурс</span>
                </div>
            <?php endif; ?>

            <div class="p-6">
                <!-- Заголовок конкурса -->
                <h3 class="text-xl font-semibold text-gray-800 mb-2">
                    <?= Html::encode($contest->title) ?>
                </h3>

                <!-- Описание -->
                <p class="text-gray-600 mb-4">
                    <?= Html::encode(mb_substr($contest->description, 0, 80)) ?>...
                </p>

                <!-- Информация о датах и статусе (адаптируйте под ваши данные) -->
                <div class="flex justify-between items-center text-sm text-gray-500 mb-4">
                    <span>📅
                        <?php if ($contest->start_date && $contest->end_date): ?>
                            <?= date('d.m.Y', strtotime($contest->start_date)) ?> - <?= date('d.m.Y', strtotime($contest->end_date)) ?>
                        <?php else: ?>
                            Дата уточняется
                        <?php endif; ?>
                    </span>
                    <span class="bg-green-100 text-green-800 px-2 py-1 rounded text-xs font-medium">
                        Активный
                    </span>
                </div>

                <!-- Кнопка просмотра в стиле дизайн-проекта -->
                <a href="<?= Url::to(['contest/view', 'id' => $contest->id]) ?>"
                   class="block w-full text-center bg-blue-600 text-white py-2 rounded-lg hover:bg-blue-700 transition-colors">
                    Подробнее
                </a>
            </div>
        </div>
    <?php endforeach; ?>
</div>