<?php

/** @var yii\web\View $this */
/** @var string $name */
/** @var string $message */
/** @var Exception $exception */

use yii\helpers\Html;

$this->title = $name;
?>

<!-- Контейнер в стиле дизайн-проекта -->
<div class="max-w-4xl mx-auto">
    <!-- Заголовок -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Ошибка</h2>
    </div>

    <!-- Основной блок ошибки -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="p-8">
            <!-- Иконка ошибки -->
            <div class="flex justify-center mb-6">
                <div class="w-20 h-20 bg-red-100 rounded-full flex items-center justify-center">
                    <span class="text-4xl text-red-600">⚠️</span>
                </div>
            </div>

            <!-- Заголовок ошибки -->
            <h1 class="text-2xl font-bold text-center text-gray-800 mb-4">
                <?= Html::encode($this->title) ?>
            </h1>

            <!-- Сообщение об ошибке в стиле alert из дизайн-проекта -->
            <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-r-lg mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-red-700">
                            <?= nl2br(Html::encode($message)) ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Описание -->
            <div class="space-y-4 text-gray-600 mb-8">
                <p>
                    Произошла ошибка при обработке вашего запроса.
                </p>
                <p>
                    Пожалуйста, свяжитесь с нами, если вы считаете, что это ошибка сервера.
                </p>
            </div>

            <!-- Кнопки действий -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?= Yii::$app->homeUrl ?>"
                   class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors text-center">
                    🏠 На главную страницу
                </a>

                <a href="javascript:history.back()"
                   class="border border-gray-300 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-50 transition-colors text-center">
                    ↩️ Вернуться назад
                </a>

                <button onclick="window.location.reload()"
                        class="border border-blue-300 text-blue-600 px-6 py-3 rounded-lg hover:bg-blue-50 transition-colors text-center">
                    🔄 Обновить страницу
                </button>
            </div>

            <!-- Дополнительная информация (только для разработки) -->
            <?php if (YII_DEBUG): ?>
                <div class="mt-8 pt-6 border-t border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-800 mb-3">Детали ошибки (для разработки):</h3>
                    <div class="bg-gray-50 p-4 rounded-lg overflow-auto max-h-60">
                        <pre class="text-sm text-gray-700"><?= Html::encode($exception) ?></pre>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>