<?php
use yii\helpers\Html;

/* @var $notifications app\models\Notification[] */
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Уведомления</h2>

        <!-- Статистика и кнопки действий -->
        <div class="flex items-center space-x-4">
            <?php
            $unreadCount = 0;
            foreach ($notifications as $n) {
                if (!$n->is_read) $unreadCount++;
            }
            ?>

            <?php if ($unreadCount > 0): ?>
                <span class="bg-red-500 text-white text-sm font-medium rounded-full px-3 py-1">
                <?= $unreadCount ?> непрочитанных
            </span>
            <?php endif; ?>


        </div>
    </div>

    <!-- Если нет уведомлений -->
<?php if (empty($notifications)): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span class="text-3xl text-gray-400">🔔</span>
        </div>
        <h3 class="text-xl font-semibold text-gray-800 mb-2">Уведомлений пока нет</h3>
        <p class="text-gray-600 mb-6">Здесь будут появляться важные обновления и сообщения</p>
        <div class="space-x-4">
            <?= Html::a('На главную', ['site/index'], [
                'class' => 'inline-block bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors'
            ]) ?>
            <?= Html::a('К моим заявкам', ['user/applications'], [
                'class' => 'inline-block border border-gray-300 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-50 transition-colors'
            ]) ?>
        </div>
    </div>

<?php else: ?>



    <!-- Список уведомлений в стиле дизайн-проекта -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="divide-y divide-gray-100">
            <?php foreach ($notifications as $n): ?>
                <div class="p-6 hover:bg-gray-50 transition-colors <?php if (!$n->is_read) echo 'bg-blue-50'; ?>">
                    <div class="flex items-start">
                        <!-- Иконка уведомления -->
                        <div class="flex-shrink-0 mr-4">
                            <?php
                            $icon = '🔔';
                            $bgColor = 'bg-blue-100';
                            $textColor = 'text-blue-600';

                            // Можно добавить разные иконки для разных типов
                            if (strpos(strtolower($n->title), 'победа') !== false ||
                                strpos(strtolower($n->title), 'выигрыш') !== false) {
                                $icon = '🏆';
                                $bgColor = 'bg-yellow-100';
                                $textColor = 'text-yellow-600';
                            } elseif (strpos(strtolower($n->title), 'ошибка') !== false ||
                                strpos(strtolower($n->title), 'проблема') !== false) {
                                $icon = '⚠️';
                                $bgColor = 'bg-red-100';
                                $textColor = 'text-red-600';
                            } elseif (strpos(strtolower($n->title), 'заявк') !== false) {
                                $icon = '📋';
                                $bgColor = 'bg-green-100';
                                $textColor = 'text-green-600';
                            }
                            ?>

                            <div class="w-12 h-12 <?= $bgColor ?> rounded-lg flex items-center justify-center">
                                <span class="text-xl <?= $textColor ?>"><?= $icon ?></span>
                            </div>

                            <!-- Индикатор непрочитанного -->
                            <?php if (!$n->is_read): ?>
                                <div class="w-3 h-3 bg-red-500 rounded-full border-2 border-white -mt-2 ml-auto"></div>
                            <?php endif; ?>
                        </div>

                        <!-- Контент уведомления -->
                        <div class="flex-1">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h4 class="font-semibold text-gray-800 text-lg">
                                        <?= Html::encode($n->title) ?>
                                        <?php if (!$n->is_read): ?>
                                            <span class="ml-2 bg-red-500 text-white text-xs rounded-full px-2 py-0.5">NEW</span>
                                        <?php endif; ?>
                                    </h4>

                                    <p class="text-gray-600 mt-1">
                                        <?= Html::encode($n->message) ?>
                                    </p>

                                    <div class="flex items-center mt-2 text-sm text-gray-500">
                                        <span class="mr-4">📅 <?= date('d.m.Y H:i', strtotime($n->created_at)) ?></span>

                                        <?php if (isset($n->type)): ?>
                                            <span class="px-2 py-1 bg-gray-100 text-gray-700 rounded text-xs">
                                            <?= Html::encode($n->type) ?>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Действия -->
                                <div class="flex space-x-2 ml-4">
                                    <?php if (!$n->is_read): ?>
                                        <?= Html::a('Прочитать', ['notification/read', 'id' => $n->id], [
                                            'class' => 'bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors text-sm',
                                        ]) ?>
                                    <?php else: ?>
                                        <span class="border border-green-300 text-green-600 px-4 py-2 rounded-lg hover:bg-green-50 transition-colors text-sm">✓ Прочитано</span>
                                    <?php endif; ?>

                                </div>
                            </div>

                            <!-- Дополнительная информация (если есть) -->
                            <?php if (isset($n->link) && $n->link): ?>
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <?= Html::a('Перейти к связанному элементу →', $n->link, [
                                        'class' => 'text-blue-600 hover:text-blue-800 font-medium text-sm'
                                    ]) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Пагинация (если нужно) -->
    <?php if (isset($pagination) && $pagination->pageCount > 1): ?>
        <div class="mt-6 flex justify-center">
            <nav class="inline-flex rounded-md shadow">
                <?php if ($pagination->page > 0): ?>
                    <?= Html::a('← Назад', ['notification/index', 'page' => $pagination->page], [
                        'class' => 'px-4 py-2 border border-gray-300 rounded-l-lg hover:bg-gray-50'
                    ]) ?>
                <?php endif; ?>

                <?php for ($i = 1; $i <= $pagination->pageCount; $i++): ?>
                    <?= Html::a($i, ['notification/index', 'page' => $i], [
                        'class' => 'px-4 py-2 border-t border-b border-gray-300 ' .
                            ($i == $pagination->page + 1 ? 'bg-blue-50 text-blue-600 border-blue-500' : 'hover:bg-gray-50')
                    ]) ?>
                <?php endfor; ?>

                <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                    <?= Html::a('Вперед →', ['notification/index', 'page' => $pagination->page + 2], [
                        'class' => 'px-4 py-2 border border-gray-300 rounded-r-lg hover:bg-gray-50'
                    ]) ?>
                <?php endif; ?>
            </nav>
        </div>
    <?php endif; ?>

    <!-- Кнопка "На главную" в стиле дизайн-проекта -->
    <div class="mt-6">
        <?= Html::a('← На главную страницу', ['site/index'], [
            'class' => 'inline-flex items-center text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>

<?php endif; ?>