<?php
use yii\helpers\Html;
use yii\helpers\Url;
?>

    <!-- Заголовок в стиле дизайн-проекта -->
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Мои заявки</h2>


    </div>

    <!-- Фильтры в стиле дизайн-проекта -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
            <div>
                <h3 class="text-lg font-semibold text-gray-800 mb-2">Фильтр</h3>

                <form method="get" action="<?= Url::to(['']) ?>" class="flex flex-col md:flex-row gap-3">
                    <!-- Фильтр по статусу -->
                    <div class="flex items-center">
                        <label for="status" class="text-sm text-gray-700 mr-2 whitespace-nowrap">Статус:</label>
                        <select name="status" id="status"
                                class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Все статусы</option>
                            <?php foreach ($statusList as $key => $label): ?>
                                <option value="<?= $key ?>" <?= $key == $currentStatus ? 'selected' : '' ?>>
                                    <?= Html::encode($label) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Фильтр по конкурсу (если есть список конкурсов) -->
                    <?php if (isset($contestList) && !empty($contestList)): ?>
                        <div class="flex items-center">
                            <label for="contest" class="text-sm text-gray-700 mr-2 whitespace-nowrap">Конкурс:</label>
                            <select name="contest_id" id="contest"
                                    class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                                <option value="">Все конкурсы</option>
                                <?php foreach ($contestList as $contest): ?>
                                    <option value="<?= $contest->id ?>" <?= isset($currentContest) && $currentContest == $contest->id ? 'selected' : '' ?>>
                                        <?= Html::encode($contest->title) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    <?php endif; ?>



                    <div class="flex space-x-2">
                        <button type="submit"
                                class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition-colors whitespace-nowrap">
                            Применить
                        </button>
                    </div>
                </form>
            </div>

            <!-- Статистика -->
            <?php
            $totalCount = count($applications);
            $activeCount = 0;
            $pendingCount = 0;
            $approvedCount = 0;

            foreach ($applications as $app) {
                if ($app->status == 'active') $activeCount++;
                if ($app->status == 'pending') $pendingCount++;
                if ($app->status == 'approved') $approvedCount++;
            }
            ?>


        </div>
    </div>

    <!-- Если нет заявок -->
<?php if (empty($applications)): ?>
    <div class="bg-white rounded-xl shadow-md p-8 text-center">
        <div class="w-20 h-20 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <span class="text-3xl text-gray-400">📋</span>
        </div>
        <h3 class="text-xl font-semibold text-gray-800 mb-2">Заявок пока нет</h3>
        <p class="text-gray-600 mb-6">Создайте свою первую заявку для участия в конкурсах</p>
        <?= Html::a('+ Создать первую заявку', ['application/create'], [
            'class' => 'inline-block bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium'
        ]) ?>
    </div>
<?php else: ?>

    <!-- Таблица заявок в стиле дизайн-проекта -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <!-- Заголовок таблицы -->
        <div class="p-6 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <h3 class="text-2xl font-bold text-gray-800">Список заявок</h3>

            </div>
        </div>

        <!-- Таблица -->
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="bg-gray-50">
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Название работы</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Конкурс</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Номинация</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Дата подачи</th>
                    <th class="text-left py-4 px-6 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                <?php foreach ($applications as $app): ?>
                    <tr class="hover:bg-gray-50 transition-colors">
                        <td class="py-4 px-6">
                            <div class="font-medium text-gray-800"><?= Html::encode($app->title) ?></div>

                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800"><?= Html::encode($app->contest->title ?? 'Не указан') ?></div>
                            <?php if (isset($app->contest) && $app->contest->end_date): ?>
                                <div class="text-xs text-gray-500 mt-1">
                                    До <?= date('d.m.Y', strtotime($app->contest->end_date)) ?>
                                </div>
                            <?php endif; ?>
                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800"><?= Html::encode($app->nomination->name ?? 'Не указана') ?></div>
                            <?php if (isset($app->age_category)): ?>
                                <div class="text-xs text-gray-500 mt-1">
                                    <?= Html::encode($app->age_category) ?>
                                </div>
                            <?php endif; ?>
                        </td>

                        <td class="py-4 px-6">
                            <?php
                            $statusColor = 'bg-gray-100 text-gray-800';
                            if ($app->status == 'approved') $statusColor = 'bg-green-100 text-green-800';
                            elseif ($app->status == 'pending') $statusColor = 'bg-yellow-100 text-yellow-800';
                            elseif ($app->status == 'rejected') $statusColor = 'bg-red-100 text-red-800';
                            elseif ($app->status == 'active') $statusColor = 'bg-blue-100 text-blue-800';
                            ?>
                            <span class="<?= $statusColor ?> px-3 py-1 rounded-full text-sm font-medium">
                            <?= Html::encode($statusList[$app->status] ?? $app->status) ?>
                        </span>
                        </td>

                        <td class="py-4 px-6">
                            <div class="text-gray-800">
                                <?= date('d.m.Y', strtotime($app->created_at)) ?>
                            </div>
                            <div class="text-xs text-gray-500">
                                <?= date('H:i', strtotime($app->created_at)) ?>
                            </div>
                        </td>

                        <td class="py-4 px-6">
                            <div class="flex space-x-2">
                                <?= Html::a('Просмотр', ['application/view', 'id' => $app->id], [
                                    'class' => 'text-blue-600 hover:text-blue-800 px-3 py-1 rounded hover:bg-blue-50 transition-colors text-sm font-medium'
                                ]) ?>

                                <?php if (in_array($app->status, ['pending', 'active'])): ?>
                                    <?= Html::a('Редактировать', ['application/update', 'id' => $app->id], [
                                        'class' => 'text-green-600 hover:text-green-800 px-3 py-1 rounded hover:bg-green-50 transition-colors text-sm font-medium'
                                    ]) ?>

                                    <?= Html::a('Отменить', ['application/cancel', 'id' => $app->id], [
                                        'class' => 'text-red-600 hover:text-red-800 px-3 py-1 rounded hover:bg-red-50 transition-colors text-sm font-medium',
                                        'data' => [
                                            'confirm' => 'Вы уверены, что хотите отменить эту заявку?',
                                            'method' => 'post',
                                        ]
                                    ]) ?>
                                <?php endif; ?>

                                <?php if ($app->status == 'approved'): ?>
                                    <?= Html::a('Сертификат', ['application/certificate', 'id' => $app->id], [
                                        'class' => 'text-purple-600 hover:text-purple-800 px-3 py-1 rounded hover:bg-purple-50 transition-colors text-sm font-medium',
                                        'target' => '_blank'
                                    ]) ?>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация (если нужно) -->
        <?php if (isset($pagination) && $pagination->pageCount > 1): ?>
            <div class="p-6 border-t border-gray-200">
                <div class="flex justify-between items-center">
                    <div class="text-sm text-gray-600">
                        Показано <?= $pagination->offset + 1 ?> - <?= min($pagination->offset + $pagination->limit, $pagination->totalCount) ?>
                        из <?= $pagination->totalCount ?> заявок
                    </div>
                    <nav class="inline-flex rounded-md shadow">
                        <?php if ($pagination->page > 0): ?>
                            <?= Html::a('← Назад', ['application/index', 'page' => $pagination->page], [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-l-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>

                        <?php for ($i = 1; $i <= $pagination->pageCount; $i++): ?>
                            <?= Html::a($i, ['application/index', 'page' => $i], [
                                'class' => 'px-4 py-2 border-t border-b border-gray-300 ' .
                                    ($i == $pagination->page + 1 ? 'bg-blue-50 text-blue-600 border-blue-500' : 'hover:bg-gray-50')
                            ]) ?>
                        <?php endfor; ?>

                        <?php if ($pagination->page < $pagination->pageCount - 1): ?>
                            <?= Html::a('Вперед →', ['application/index', 'page' => $pagination->page + 2], [
                                'class' => 'px-4 py-2 border border-gray-300 rounded-r-lg hover:bg-gray-50'
                            ]) ?>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        <?php endif; ?>
    </div>



<?php endif; ?>