<?php

use yii\widgets\ActiveForm;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use app\models\Nomination;
use app\models\AgeCategory;
use app\models\Contest;

/* @var $model app\models\Application */
/* @var $nominations app\models\Nomination[] */
/* @var $ageCategories app\models\AgeCategory[] */
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Подача заявки</h2>
    <?= Html::a('← Назад к заявкам', ['application/index'], [
        'class' => 'text-blue-600 hover:text-blue-800 font-medium'
    ]) ?>
</div>

<!-- Основной блок формы -->
<div class="bg-white rounded-xl shadow-md p-6 max-w-2xl">
    <!-- Информация о конкурсе (если выбран) -->
    <?php if (isset($selectedContest) && $selectedContest): ?>
        <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-500 rounded-r-lg">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <h4 class="font-semibold text-blue-800">Конкурс: <?= Html::encode($selectedContest->title) ?></h4>
                    <p class="text-sm text-blue-700 mt-1">
                        Приём заявок до: <?= date('d.m.Y', strtotime($selectedContest->end_date)) ?>
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php $form = ActiveForm::begin([
        'id' => 'application-form',
        'options' => [
            'class' => 'space-y-6',
            'enctype' => 'multipart/form-data'
        ]
    ]); ?>


    <!-- Шаг 2: Информация об участнике -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">1. Информация об участнике</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?= $form->field($model, 'participant_surname', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Иванов'
                ]
            ])->label('Фамилия *') ?>

            <?= $form->field($model, 'participant_name', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Иван'
                ]
            ])->label('Имя *') ?>
        </div>

        <?= $form->field($model, 'participant_patronymic', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Иванович (если есть)'
            ]
        ])->label('Отчество') ?>

        <!-- Название работы -->
        <?= $form->field($model, 'title', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Название вашей работы'
            ]
        ])->label('Название работы *') ?>

        <!-- Описание работы -->
    </div>

    <!-- Шаг 3: Параметры заявки -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">2. Параметры заявки</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Номинация -->
            <?= $form->field($model, 'nomination_id', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]
            ])->dropDownList(
                ArrayHelper::map($nominations, 'id', 'name'),
                ['prompt' => 'Выберите номинацию']
            )->label('Номинация *') ?>

            <!-- Возрастная категория -->
            <?= $form->field($model, 'age_category_id', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500'
                ]
            ])->dropDownList(
                ArrayHelper::map($ageCategories, 'id', 'name'),
                ['prompt' => 'Выберите возрастную категорию']
            )->label('Возрастная категория *') ?>
        </div>
    </div>

    <!-- Шаг 4: Учреждение и руководитель -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">3. Учреждение и руководитель</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <?= $form->field($model, 'institution', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'Название учебного заведения'
                ]
            ])->label('Учреждение') ?>

            <?= $form->field($model, 'supervisor', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'placeholder' => 'ФИО руководителя'
                ]
            ])->label('Руководитель') ?>
        </div>
    </div>

    <!-- Шаг 5: Загрузка файлов -->
    <div class="pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4">4. Загрузка файлов</h3>

        <!-- Основной файл -->
        <div class="mb-6">
            <?= $form->field($model, 'file_path', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'block w-full text-sm text-gray-500
                        file:mr-4 file:py-2 file:px-4
                        file:rounded-lg file:border-0
                        file:text-sm file:font-medium
                        file:bg-blue-50 file:text-blue-700
                        hover:file:bg-blue-100',
                    'accept' => '.mp4,.mkv,.png,.avi,.jpg,.jpeg,.pdf,.doc,.docx'
                ]
            ])->fileInput()->label('Основной файл работы *') ?>

            <div class="mt-2 text-sm text-gray-500">
                <p>Разрешённые форматы: MP4, MKV, PNG, AVI, JPG, JPEG, PDF, DOC, DOCX</p>
                <p>Максимальный размер: 100 MB</p>
            </div>
        </div>

        <!-- Дополнительные файлы (если поддерживается) -->
        <?php if ($model->hasAttribute('additional_files')): ?>
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700 mb-2">Дополнительные файлы (необязательно)</label>
                <div id="additional-files">
                    <div class="flex items-center mb-2">
                        <input type="file" name="additional_files[]"
                               class="flex-1 px-4 py-2 border border-gray-300 rounded-lg">
                        <button type="button" onclick="addFileField()"
                                class="ml-2 bg-gray-200 text-gray-700 px-3 py-2 rounded-lg hover:bg-gray-300">
                            +
                        </button>
                    </div>
                </div>
                <p class="text-sm text-gray-500 mt-1">Можно прикрепить дополнительные материалы (скриншоты, фото и т.д.)</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Кнопки отправки в стиле дизайн-проекта -->
    <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
        <?= Html::submitButton('Отправить заявку', [
            'class' => 'flex-1 bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-medium',
            'id' => 'submit-btn'
        ]) ?>

        <?= Html::a('Отмена', ['application/index'], [
            'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 transition-colors text-center'
        ]) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>

<!-- JavaScript для динамического добавления файлов -->
<?php if ($model->hasAttribute('additional_files')): ?>
    <script>
        let fileCount = 1;

        function addFileField() {
            fileCount++;
            const container = document.getElementById('additional-files');
            const div = document.createElement('div');
            div.className = 'flex items-center mb-2';
            div.innerHTML = `
        <input type="file" name="additional_files[]"
               class="flex-1 px-4 py-2 border border-gray-300 rounded-lg">
        <button type="button" onclick="removeFileField(this)"
                class="ml-2 bg-red-100 text-red-700 px-3 py-2 rounded-lg hover:bg-red-200">
            ×
        </button>
    `;
            container.appendChild(div);
        }

        function removeFileField(button) {
            if (fileCount > 1) {
                button.parentElement.remove();
                fileCount--;
            }
        }
    </script>
<?php endif; ?>

<!-- JavaScript для валидации -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('application-form');
        const submitBtn = document.getElementById('submit-btn');
        const rulesAgreement = document.getElementById('rules-agreement');
        const fileInput = document.querySelector('input[type="file"]');

        // Проверка файла
        if (fileInput) {
            fileInput.addEventListener('change', function() {
                const file = this.files[0];
                if (file) {
                    // Проверка размера (100MB)
                    if (file.size > 100 * 1024 * 1024) {
                        alert('Файл слишком большой. Максимальный размер: 100 MB');
                        this.value = '';
                    }

                    // Проверка расширения
                    const allowedExtensions = /(\.mp4|\.mkv|\.png|\.avi|\.jpg|\.jpeg|\.pdf|\.doc|\.docx)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        alert('Недопустимый формат файла. Разрешены: MP4, MKV, PNG, AVI, JPG, JPEG, PDF, DOC, DOCX');
                        this.value = '';
                    }
                }
            });
        }

        // Валидация формы
        if (form) {
            form.addEventListener('submit', function(e) {
                // Проверка согласия с правилами
                if (!rulesAgreement.checked) {
                    e.preventDefault();
                    alert('Вы должны согласиться с правилами конкурса');
                    rulesAgreement.focus();
                    return;
                }

                // Можно добавить дополнительные проверки
                const requiredFields = form.querySelectorAll('[required]');
                let isValid = true;

                requiredFields.forEach(field => {
                    if (!field.value.trim()) {
                        isValid = false;
                        field.classList.add('border-red-500');
                    } else {
                        field.classList.remove('border-red-500');
                    }
                });

                if (!isValid) {
                    e.preventDefault();
                    alert('Пожалуйста, заполните все обязательные поля (помеченные *)');
                }
            });
        }
    });
</script>