<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>

<!-- Основной контент -->
<div id="user-update" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Редактирование пользователя</h2>
            <p class="text-gray-600 mt-2">ID: <span class="font-semibold">#<?= $model->id ?></span> | Логин: <span class="font-semibold"><?= Html::encode($model->login) ?></span></p>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная форма -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <h3 class="text-2xl font-bold text-gray-800 mb-6">Основная информация</h3>

            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Фамилия -->
                <div>
                    <?= $form->field($model, 'surname', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        ',
                        'options' => ['class' => 'form-group']
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'Иванов'
                    ]) ?>
                </div>

                <!-- Имя -->
                <div>
                    <?= $form->field($model, 'name', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'Иван'
                    ]) ?>
                </div>
            </div>

            <!-- Отчество -->
            <div>
                <?= $form->field($model, 'patronymic', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Необязательное поле</div>
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'Иванович'
                ]) ?>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Логин -->
                <div>
                    <?= $form->field($model, 'login', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                            <div class="text-sm text-gray-500 mt-1">Уникальный логин для входа</div>
                        '
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'ivanov'
                    ]) ?>
                </div>

                <!-- Роль -->
                <div>
                    <?= $form->field($model, 'role', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                    ])->dropDownList([
                        'participant' => '👤 Участник',
                        'expert' => '⭐ Эксперт',
                        'admin' => '👑 Администратор',
                    ], [
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white'
                    ]) ?>
                </div>
            </div>

            <!-- Пароль -->
            <div>
                <?= $form->field($model, 'password_hash', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">Новый пароль</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Оставьте пустым, если не хотите менять пароль</div>
                    '
                ])->passwordInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                    'placeholder' => 'Введите новый пароль'
                ]) ?>
            </div>

            <!-- Кнопки -->
            <div class="mt-8 flex space-x-4">
                <?= Html::submitButton('Сохранить изменения', [
                    'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium text-lg'
                ]) ?>

                <?= Html::a('Отмена', ['index'], [
                    'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 px-6 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>

        <!-- Боковая панель с информацией -->
        <div class="space-y-6">
            <!-- Информация о пользователе -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h4 class="text-lg font-semibold text-gray-800 mb-4">📊 Информация</h4>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Статус:</span>
                        <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm font-medium">
                            <?= $model->status === 'active' ? 'Активен' : 'Заблокирован' ?>
                        </span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Email:</span>
                        <span class="font-medium"><?= Html::encode($model->email) ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Дата регистрации:</span>
                        <span class="font-medium"><?= date('d.m.Y', strtotime($model->created_at)) ?></span>
                    </div>
                </div>
            </div>




        </div>
    </div>
</div>

<!-- Дополнительные стили -->
<style>

    /* Кастомный селект */
    select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3E%3C/svg%3E");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .grid-cols-2 {
            grid-template-columns: 1fr;
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    // Подтверждение изменения роли
    document.addEventListener('DOMContentLoaded', function() {
        const roleSelect = document.querySelector('#user-role');
        if (roleSelect) {
            const originalRole = roleSelect.value;

            roleSelect.addEventListener('change', function() {
                if (this.value !== originalRole && (this.value === 'admin' || originalRole === 'admin')) {
                    if (!confirm('Вы уверены, что хотите изменить роль администратора? Это может повлиять на доступ к системным функциям.')) {
                        this.value = originalRole;
                        return;
                    }
                }

                // Показать предупреждение при выборе администратора
                if (this.value === 'admin') {
                    alert('⚠️ Внимание! Пользователь с ролью администратора получит полный доступ ко всем функциям системы.');
                }
            });
        }

        // Валидация пароля
        const passwordInput = document.querySelector('input[type="password"]');
        if (passwordInput) {
            const passwordHelp = document.createElement('div');
            passwordHelp.className = 'text-sm mt-1 hidden';
            passwordHelp.id = 'password-strength';
            passwordInput.parentNode.appendChild(passwordHelp);

            passwordInput.addEventListener('input', function() {
                const password = this.value;
                passwordHelp.classList.remove('hidden');

                if (password.length === 0) {
                    passwordHelp.textContent = 'Оставьте пустым, чтобы не менять пароль';
                    passwordHelp.className = 'text-sm text-gray-500 mt-1';
                    return;
                }

                let strength = 0;
                let message = '';
                let color = 'text-red-500';

                if (password.length >= 8) strength++;
                if (/[A-Z]/.test(password)) strength++;
                if (/[0-9]/.test(password)) strength++;
                if (/[^A-Za-z0-9]/.test(password)) strength++;

                switch(strength) {
                    case 0:
                    case 1:
                        message = 'Слабый пароль';
                        color = 'text-red-500';
                        break;
                    case 2:
                        message = 'Средний пароль';
                        color = 'text-yellow-500';
                        break;
                    case 3:
                        message = 'Хороший пароль';
                        color = 'text-green-500';
                        break;
                    case 4:
                        message = 'Отличный пароль';
                        color = 'text-green-600';
                        break;
                }

                passwordHelp.textContent = message;
                passwordHelp.className = `text-sm font-medium mt-1 ${color}`;
            });
        }
    });
</script>