<?php
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
?>

<!-- Основной контент -->
<div id="users-index" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Управление пользователями</h2>
        <?= Html::a('Создать пользователя', ['user-create'], [
            'class' => 'bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors flex items-center'
        ]) ?>
    </div>

    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">Список пользователей</h3>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">#</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Фамилия</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Имя</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Email</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Роль</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Статус</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Действия</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($dataProvider->getModels() as $index => $model): ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors">
                        <td class="py-4 text-gray-600"><?= $index + 1 ?></td>
                        <td class="py-4 font-medium text-gray-800"><?= Html::encode($model->surname) ?></td>
                        <td class="py-4 text-gray-800"><?= Html::encode($model->name) ?></td>
                        <td class="py-4 text-gray-800"><?= Html::encode($model->email) ?></td>
                        <td class="py-4">
                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                <?= Html::encode($model->role) ?>
                            </span>
                        </td>
                        <td class="py-4">
                            <?php
                            $statusClass = $model->status === 'blocked'
                                ? 'bg-red-100 text-red-800'
                                : 'bg-green-100 text-green-800';
                            ?>
                            <span class="px-3 py-1 rounded-full text-sm font-medium <?= $statusClass ?>">
                                <?= ucfirst(Html::encode($model->status)) ?>
                            </span>
                        </td>
                        <td class="py-4">
                            <div class="flex space-x-3">
                                <?= Html::a('Редактировать', ['user-update', 'id' => $model->id], [
                                    'class' => 'text-blue-600 hover:text-blue-800 hover:underline text-sm'
                                ]) ?>

                                <?= Html::a('Удалить', ['user-delete', 'id' => $model->id], [
                                    'class' => 'text-red-600 hover:text-red-800 hover:underline text-sm',
                                ]) ?>

                                <?php if ($model->status !== 'blocked'): ?>
                                    <?= Html::a('Заблокировать', ['admin/block', 'id' => $model->id], [
                                        'class' => 'text-red-600 hover:text-red-800 hover:underline text-sm',
                                    ]) ?>
                                <?php else: ?>
                                    <?= Html::a('Разблокировать', ['admin/unblock', 'id' => $model->id], [
                                        'class' => 'text-green-600 hover:text-green-800 hover:underline text-sm',
                                    ]) ?>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация в стиле дизайна -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * ($dataProvider->pagination->page) + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> пользователей
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['index', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['index', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['index', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Стили для адаптации -->
<style>

    /* Адаптация под мобильные устройства */
    @media (max-width: 768px) {
        .table-responsive {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        table {
            min-width: 700px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .flex.space-x-3 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }
    }
</style>

<script>
    // Если используется SPA навигация как в дизайн-проекте
    document.addEventListener('DOMContentLoaded', function() {
        // Добавляем обработчики для кнопок фильтрации статуса
        document.querySelectorAll('button.border-gray-300').forEach(button => {
            button.addEventListener('click', function() {
                // Здесь можно добавить AJAX-фильтрацию
                console.log('Фильтр:', this.textContent.trim());
            });
        });
    });
</script>