<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
?>

<!-- Основной контент -->
<div id="nomination-create" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">Создание номинации</h2>
        <?= Html::a('← Назад к списку', ['index'], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная форма -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <div class="flex items-center mb-6">
                <div class="p-3 bg-blue-100 rounded-lg mr-4">
                    <span class="text-2xl text-blue-600">🏆</span>
                </div>
                <div>
                    <h3 class="text-2xl font-bold text-gray-800">Добавить новую номинацию</h3>
                    <p class="text-gray-600">Заполните основные данные о номинации</p>
                </div>
            </div>

            <?php $form = ActiveForm::begin([
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <!-- Название номинации -->
            <div>
                <?= $form->field($model, 'name', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                       
                    '
                ])->textInput([
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors text-lg font-medium',
                    'placeholder' => 'Например: «Лучшая хореография» или «Современный танец»',
                    'id' => 'nomination-name'
                ])->label('🎯 Название номинации *') ?>
            </div>

            <!-- Описание (если есть в модели) -->
            <?php if (isset($model->description)): ?>
                <div>
                    <?= $form->field($model, 'description', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Опишите критерии и особенности номинации</div>
                    '
                    ])->textarea([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'rows' => 4,
                        'placeholder' => 'Опишите особенности, критерии оценки и требования к участникам этой номинации...',
                        'id' => 'nomination-description'
                    ])->label('📝 Описание номинации') ?>

                    <div class="text-xs text-gray-500 text-right mt-1">
                        <span id="char-count">0</span> / 500 символов
                    </div>
                </div>
            <?php endif; ?>

            <!-- Иконка (если есть в модели) -->
            <?php if (isset($model->icon)): ?>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">🎨 Иконка номинации</label>
                    <div class="grid grid-cols-4 md:grid-cols-8 gap-2 mb-4">
                        <?php
                        $icons = ['🎭', '🎨', '🎤', '💃', '🎼', '🎬', '📸', '✍️', '🎹', '🎻', '🎷', '🥁', '🩰', '🎪', '🌟', '🏅'];
                        foreach ($icons as $icon): ?>
                            <button type="button" class="p-3 border border-gray-300 rounded-lg hover:bg-gray-50 text-xl transition-colors icon-select" data-icon="<?= $icon ?>">
                                <?= $icon ?>
                            </button>
                        <?php endforeach; ?>
                    </div>
                    <?= $form->field($model, 'icon', [
                        'template' => '{input}{error}'
                    ])->hiddenInput(['id' => 'nomination-icon']) ?>
                </div>
            <?php endif; ?>

            <!-- Критерии оценки (если есть) -->
            <?php if (isset($model->criteria)): ?>
                <div>
                    <?= $form->field($model, 'criteria', [
                        'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Укажите критерии оценки через запятую</div>
                    '
                    ])->textInput([
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                        'placeholder' => 'Например: Техника, Артистизм, Оригинальность, Сложность'
                    ])->label('📊 Критерии оценки') ?>
                </div>
            <?php endif; ?>

            <!-- Возрастные ограничения (если есть) -->
            <?php if (isset($model->min_age) || isset($model->max_age)): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <?php if (isset($model->min_age)): ?>
                        <div>
                            <?= $form->field($model, 'min_age', [
                                'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                            ])->textInput([
                                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                                'type' => 'number',
                                'placeholder' => '6'
                            ])->label('👶 Минимальный возраст') ?>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($model->max_age)): ?>
                        <div>
                            <?= $form->field($model, 'max_age', [
                                'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                        '
                            ])->textInput([
                                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors',
                                'type' => 'number',
                                'placeholder' => '18'
                            ])->label('👴 Максимальный возраст') ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Кнопки -->
            <div class="mt-8 flex space-x-4">
                <?= Html::submitButton('🏆 Создать номинацию', [
                    'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium text-lg',
                    'id' => 'submit-btn'
                ]) ?>


            </div>

            <?php ActiveForm::end(); ?>
        </div>


</div>

<!-- Стили -->
<style>

    /* Выбранная иконка */
    .icon-select.selected {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .grid-cols-2, .md\:grid-cols-8 {
            grid-template-columns: repeat(4, 1fr);
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Элементы DOM
        const nameInput = document.getElementById('nomination-name');
        const descriptionInput = document.getElementById('nomination-description');
        const iconInput = document.getElementById('nomination-icon');
        const charCount = document.getElementById('char-count');
        const submitBtn = document.getElementById('submit-btn');

        // Предварительный просмотр
        const previewName = document.getElementById('preview-name');
        const previewDescription = document.getElementById('preview-description');
        const previewIcon = document.getElementById('preview-icon');

        // Обновление предварительного просмотра
        function updatePreview() {
            if (nameInput && previewName) {
                previewName.textContent = nameInput.value || 'Название номинации';
            }

            if (descriptionInput && previewDescription) {
                previewDescription.textContent = descriptionInput.value || 'Описание номинации появится здесь...';
            }

            if (charCount && descriptionInput) {
                charCount.textContent = descriptionInput.value.length;
            }
        }

        // Обработчики событий
        if (nameInput) {
            nameInput.addEventListener('input', updatePreview);
        }

        if (descriptionInput) {
            descriptionInput.addEventListener('input', updatePreview);
            // Инициализация счетчика символов
            if (charCount) {
                charCount.textContent = descriptionInput.value.length;
            }
        }

        // Выбор иконки
        const iconButtons = document.querySelectorAll('.icon-select');
        iconButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Сброс предыдущего выбора
                iconButtons.forEach(btn => btn.classList.remove('selected'));

                // Установка нового выбора
                this.classList.add('selected');
                const icon = this.getAttribute('data-icon');

                if (iconInput) {
                    iconInput.value = icon;
                }

                if (previewIcon) {
                    previewIcon.textContent = icon;
                }
            });
        });

        // Примеры номинаций
        const exampleButtons = document.querySelectorAll('button[data-example]');
        exampleButtons.forEach(button => {
            button.addEventListener('click', function() {
                const exampleType = this.getAttribute('data-example');
                const examples = {
                    'Хореография': {
                        name: 'Лучшая хореография',
                        desc: 'Номинация для танцевальных коллективов и сольных исполнителей. Оценивается техника, синхронность, оригинальность постановки.',
                        icon: '💃'
                    },
                    'Вокал': {
                        name: 'Эстрадный вокал',
                        desc: 'Для сольных вокалистов и вокальных ансамблей. Критерии: чистота интонации, тембр, артистизм, сложность репертуара.',
                        icon: '🎤'
                    },
                    'ИЗО': {
                        name: 'Изобразительное искусство',
                        desc: 'Рисунок, живопись, графика. Оценивается техника исполнения, композиция, цветовое решение, оригинальность замысла.',
                        icon: '🎨'
                    },
                    'Театр': {
                        name: 'Театральное искусство',
                        desc: 'Драматические спектакли, художественное слово. Критерии: актёрское мастерство, режиссура, сценография, целостность постановки.',
                        icon: '🎭'
                    }
                };

                const example = examples[exampleType];
                if (example) {
                    if (nameInput) {
                        nameInput.value = example.name;
                        nameInput.focus();
                    }

                    if (descriptionInput) {
                        descriptionInput.value = example.desc;
                    }

                    // Выбор соответствующей иконки
                    iconButtons.forEach(btn => {
                        if (btn.getAttribute('data-icon') === example.icon) {
                            btn.click();
                        }
                    });

                    updatePreview();

                    // Плавная прокрутка к форме
                    document.querySelector('form').scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Валидация формы
        const form = document.querySelector('form');
        if (form) {
            form.addEventListener('submit', function(e) {
                if (!nameInput || !nameInput.value.trim()) {
                    e.preventDefault();
                    alert('Пожалуйста, укажите название номинации');
                    nameInput.focus();
                    nameInput.classList.add('border-red-500');
                    return false;
                }

                // Показать индикатор загрузки
                if (submitBtn) {
                    const originalText = submitBtn.innerHTML;
                    submitBtn.innerHTML = '<span class="flex items-center justify-center"><svg class="animate-spin h-5 w-5 mr-2 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Создание...</span>';
                    submitBtn.disabled = true;

                    setTimeout(() => {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }, 3000);
                }
            });
        }

        // Инициализация предварительного просмотра
        updatePreview();

        // Автовыбор первой иконки
        if (iconButtons.length > 0 && !iconInput?.value) {
            iconButtons[0].click();
        }
    });
</script>