<?php
use yii\helpers\Html;

/* @var $stats array */
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800">Панель администратора</h2>
</div>

<!-- Статистика системы -->
<?php if (isset($stats)): ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Пользователи -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-blue-600">👥</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['users'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Пользователей</p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <div class="flex justify-between text-xs">
                    <span class="text-gray-600">Участников: <?= $stats['participants'] ?? 0 ?></span>
                    <span class="text-gray-600">Экспертов: <?= $stats['experts'] ?? 0 ?></span>
                </div>
            </div>
        </div>

        <!-- Конкурсы -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-green-600">🏆</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['contests'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Конкурсов</p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <div class="flex justify-between text-xs">
                    <span class="text-green-600">Активных: <?= $stats['active_contests'] ?? 0 ?></span>
                    <span class="text-gray-600">Всего: <?= $stats['contests'] ?? 0 ?></span>
                </div>
            </div>
        </div>

        <!-- Заявки -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-yellow-600">📋</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['applications'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Заявок</p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <div class="flex justify-between text-xs">
                    <span class="text-blue-600">На проверке: <?= $stats['pending_apps'] ?? 0 ?></span>
                    <span class="text-green-600">Принято: <?= $stats['approved_apps'] ?? 0 ?></span>
                </div>
            </div>
        </div>

        <!-- Оценки -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mr-4">
                    <span class="text-xl text-purple-600">⭐</span>
                </div>
                <div>
                    <p class="text-2xl font-bold text-gray-800"><?= $stats['evaluations'] ?? 0 ?></p>
                    <p class="text-sm text-gray-600">Оценок</p>
                </div>
            </div>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <div class="flex justify-between text-xs">
                    <span class="text-yellow-600">Черновики: <?= $stats['draft_evals'] ?? 0 ?></span>
                    <span class="text-green-600">Завершено: <?= $stats['completed_evals'] ?? 0 ?></span>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Быстрый доступ -->
<div class="bg-white rounded-xl shadow-md p-6 mb-8">
    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
        <span class="mr-2">⚡</span> Быстрый доступ
    </h3>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <!-- Основные разделы -->
        <div class="bg-blue-50 border border-blue-100 rounded-lg p-4 hover:bg-blue-100 transition-colors">
            <?= Html::a('🏆 Конкурсы', ['admin/contests'], [
                'class' => 'block text-blue-700 font-medium'
            ]) ?>
            <p class="text-sm text-blue-600 mt-1">Управление конкурсами, создание, редактирование</p>
        </div>

        <div class="bg-green-50 border border-green-100 rounded-lg p-4 hover:bg-green-100 transition-colors">
            <?= Html::a('👥 Пользователи', ['admin/users'], [
                'class' => 'block text-green-700 font-medium'
            ]) ?>
            <p class="text-sm text-green-600 mt-1">Управление пользователями, роли, доступы</p>
        </div>

        <div class="bg-yellow-50 border border-yellow-100 rounded-lg p-4 hover:bg-yellow-100 transition-colors">
            <?= Html::a('📋 Заявки', ['admin/applications'], [
                'class' => 'block text-yellow-700 font-medium'
            ]) ?>
            <p class="text-sm text-yellow-600 mt-1">Просмотр и управление всеми заявками</p>
        </div>

        <!-- Дополнительные разделы -->
        <div class="bg-purple-50 border border-purple-100 rounded-lg p-4 hover:bg-purple-100 transition-colors">
            <?= Html::a('⭐ Оценки', ['admin/evaluations'], [
                'class' => 'block text-purple-700 font-medium'
            ]) ?>
            <p class="text-sm text-purple-600 mt-1">Просмотр и управление оценками экспертов</p>
        </div>

        <div class="bg-pink-50 border border-pink-100 rounded-lg p-4 hover:bg-pink-100 transition-colors">
            <?= Html::a('🏅 Номинации', ['admin/nominations'], [
                'class' => 'block text-pink-700 font-medium'
            ]) ?>
            <p class="text-sm text-pink-600 mt-1">Управление номинациями конкурсов</p>
        </div>

        <div class="bg-indigo-50 border border-indigo-100 rounded-lg p-4 hover:bg-indigo-100 transition-colors">
            <?= Html::a('🎂 Возрастные категории', ['admin/age-categories'], [
                'class' => 'block text-indigo-700 font-medium'
            ]) ?>
            <p class="text-sm text-indigo-600 mt-1">Управление возрастными категориями</p>
        </div>
    </div>
</div>

