<?php
use yii\helpers\Html;
use yii\grid\GridView;
?>

<!-- Основной контент -->
<div id="expert-assignments-index" class="page">
    <div class="flex justify-between items-center mb-8">
        <h2 class="text-3xl font-bold text-gray-800">👨‍⚖️ Назначение экспертов</h2>

    </div>





    <!-- Таблица назначений -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h3 class="text-2xl font-bold text-gray-800">Список назначений экспертов</h3>

        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                <tr class="border-b border-gray-200">
                    <th class="text-left py-3 font-semibold text-gray-700">Эксперт</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Конкурс</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Номинация</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Возрастная категория</th>
                    <th class="text-left py-3 font-semibold text-gray-700">Статус</th>
                </tr>
                </thead>
                <tbody>
                <?php
                // Считаем нагрузку экспертов для подсветки
                $expertLoadCount = [];
                foreach ($dataProvider->getModels() as $assignment) {
                    $expertId = $assignment->expert_id;
                    $expertLoadCount[$expertId] = ($expertLoadCount[$expertId] ?? 0) + 1;
                }

                foreach ($dataProvider->getModels() as $index => $assignment):
                    $load = $expertLoadCount[$assignment->expert_id] ?? 0;
                    $isOverloaded = $load > 3;
                    ?>
                    <tr class="border-b border-gray-100 hover:bg-gray-50 transition-colors" data-expert-id="<?= $assignment->expert_id ?>" data-load="<?= $load ?>">


                        <!-- Эксперт -->
                        <td class="py-4">
                            <div class="flex items-center">
                                <div class="p-2 <?= $isOverloaded ? 'bg-red-100' : 'bg-blue-100' ?> rounded-lg mr-3">
                                    <span class="<?= $isOverloaded ? 'text-red-600' : 'text-blue-600' ?>">
                                        👨‍⚖️
                                    </span>
                                </div>
                                <div>
                                    <h4 class="font-bold text-gray-800"><?= Html::encode($assignment->expert->surname . ' ' . $assignment->expert->name) ?></h4>
                                    <div class="text-sm text-gray-500">
                                        <?= Html::encode($assignment->expert->email) ?>
                                    </div>
                                    <div class="text-xs <?= $isOverloaded ? 'text-red-500' : 'text-gray-400' ?> mt-1">
                                        Нагрузка: <span class="font-semibold"><?= $load ?></span> заданий
                                    </div>
                                </div>
                            </div>
                        </td>

                        <!-- Конкурс -->
                        <td class="py-4">
                            <div class="font-medium text-gray-800"><?= Html::encode($assignment->contest->title) ?></div>
                            <div class="text-sm text-gray-500">
                                <?= date('d.m.Y', strtotime($assignment->contest->start_date)) ?> -
                                <?= date('d.m.Y', strtotime($assignment->contest->end_date)) ?>
                            </div>
                        </td>

                        <!-- Номинация -->
                        <td class="py-4">
                            <?php if ($assignment->nomination_id): ?>
                                <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm">
                                    <?= Html::encode($assignment->nomination->name) ?>
                                </span>
                            <?php else: ?>
                                <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm">
                                    🎯 Все номинации
                                </span>
                            <?php endif; ?>
                        </td>

                        <!-- Возрастная категория -->
                        <td class="py-4">
                            <?php if ($assignment->age_category_id): ?>
                                <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-sm">
                                    <?= Html::encode($assignment->ageCategory->name) ?>
                                </span>
                            <?php else: ?>
                                <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-sm">
                                    👶 Все возрастные группы
                                </span>
                            <?php endif; ?>
                        </td>

                        <!-- Статус -->
                        <td class="py-4">
                            <?php
                            // Проверяем активность конкурса
                            $now = time();
                            $startDate = strtotime($assignment->contest->start_date);
                            $endDate = strtotime($assignment->contest->end_date);

                            if ($now < $startDate) {
                                $status = 'Ожидает начала';
                                $statusClass = 'bg-yellow-100 text-yellow-800';
                            } elseif ($now > $endDate) {
                                $status = 'Завершён';
                                $statusClass = 'bg-gray-100 text-gray-800';
                            } else {
                                $status = 'Активен';
                                $statusClass = 'bg-green-100 text-green-800';
                            }
                            ?>
                            <span class="px-3 py-1 rounded-full text-sm font-medium <?= $statusClass ?>">
                                <?= $status ?>
                            </span>
                            <div class="text-xs text-gray-500 mt-1">
                                <?= date('d.m.Y', $startDate) ?>
                            </div>
                        </td>


                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Пагинация -->
        <?php if ($dataProvider->pagination->pageCount > 1): ?>
            <div class="mt-6 flex justify-between items-center">
                <div class="text-sm text-gray-600">
                    Показано <?= $dataProvider->pagination->pageSize * $dataProvider->pagination->page + 1 ?>-
                    <?= min($dataProvider->pagination->pageSize * ($dataProvider->pagination->page + 1), $dataProvider->totalCount) ?>
                    из <?= $dataProvider->totalCount ?> назначений
                </div>
                <div class="flex space-x-2">
                    <?php if ($dataProvider->pagination->page > 0): ?>
                        <?= Html::a('« Назад', ['index', 'page' => $dataProvider->pagination->page], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>

                    <?php for ($i = 0; $i < $dataProvider->pagination->pageCount; $i++): ?>
                        <?php if (abs($i - $dataProvider->pagination->page) <= 2): ?>
                            <?= Html::a($i + 1, ['index', 'page' => $i], [
                                'class' => 'px-4 py-2 rounded-lg ' . ($i == $dataProvider->pagination->page
                                        ? 'bg-blue-600 text-white'
                                        : 'border border-gray-300 hover:bg-gray-50')
                            ]) ?>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <?php if ($dataProvider->pagination->page < $dataProvider->pagination->pageCount - 1): ?>
                        <?= Html::a('Вперед »', ['index', 'page' => $dataProvider->pagination->page + 2], [
                            'class' => 'px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50'
                        ]) ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Пустое состояние -->
    <?php if ($dataProvider->totalCount == 0): ?>
        <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-8 text-center mt-6">
            <div class="text-6xl mb-4">👨‍⚖️</div>
            <h3 class="text-2xl font-bold text-yellow-800 mb-2">Назначений экспертов пока нет</h3>
            <p class="text-yellow-600 mb-6">Назначьте экспертов для оценки заявок в конкурсах</p>
            <?= Html::a('➕ Создать первое назначение', ['expert-assignment-create'], [
                'class' => 'bg-yellow-500 text-white px-6 py-3 rounded-lg hover:bg-yellow-600 transition-colors inline-flex items-center'
            ]) ?>
        </div>
    <?php endif; ?>


</div>

<!-- Стили -->
<style>

    /* Адаптивность */
    @media (max-width: 768px) {
        table {
            min-width: 1000px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .grid-cols-4 {
            grid-template-columns: repeat(2, 1fr);
        }

        .flex.space-x-2, .flex.space-x-3 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }

        .md\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Фильтрация
        const filterAll = document.getElementById('filter-all');
        const filterOverloaded = document.getElementById('filter-overloaded');
        const filterAvailable = document.getElementById('filter-available');
        const tableRows = document.querySelectorAll('tbody tr');

        function resetFilters() {
            [filterAll, filterOverloaded, filterAvailable].forEach(btn => {
                btn.classList.remove('bg-blue-600', 'text-white');
                btn.classList.add('border', 'border-gray-300', 'text-gray-700');
            });
        }

        filterAll.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => row.style.display = '');
        });

        filterOverloaded.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => {
                const load = parseInt(row.getAttribute('data-load')) || 0;
                row.style.display = load > 3 ? '' : 'none';
            });
        });

        filterAvailable.addEventListener('click', function() {
            resetFilters();
            this.classList.remove('border', 'border-gray-300', 'text-gray-700');
            this.classList.add('bg-blue-600', 'text-white');

            tableRows.forEach(row => {
                const load = parseInt(row.getAttribute('data-load')) || 0;
                row.style.display = load <= 2 ? '' : 'none';
            });
        });

        // Подсветка перегруженных экспертов
        tableRows.forEach(row => {
            const load = parseInt(row.getAttribute('data-load')) || 0;
            if (load > 3) {
                row.classList.add('bg-gradient-to-r', 'from-red-50', 'to-transparent');

                // Добавляем предупреждение
                const warningBadge = document.createElement('span');
                warningBadge.className = 'ml-2 text-xs bg-red-500 text-white px-2 py-1 rounded-full';
                warningBadge.textContent = '⚠️ Перегружен';
                row.querySelector('.font-bold.text-gray-800').appendChild(warningBadge);
            }

            // Подсветка по статусу конкурса
            const statusCell = row.querySelector('.bg-green-100, .bg-yellow-100, .bg-gray-100');
            if (statusCell && statusCell.textContent.includes('Активен')) {
                row.classList.add('border-l-4', 'border-l-green-500');
            }
        });

        // Фильтрация через select
        const expertSelect = document.querySelector('select:first-child');
        const contestSelect = document.querySelector('select:nth-child(2)');
        const typeSelect = document.querySelector('select:nth-child(3)');

        function applyFilters() {
            const selectedExpert = expertSelect ? expertSelect.value : '';
            const selectedContest = contestSelect ? contestSelect.value : '';
            const selectedType = typeSelect ? typeSelect.value : '';

            tableRows.forEach(row => {
                const expertId = row.getAttribute('data-expert-id');
                const nominationCell = row.querySelector('.bg-purple-100, .bg-blue-100');
                const ageCell = row.querySelector('.bg-green-100, .bg-yellow-100');

                let show = true;

                // Фильтр по эксперту
                if (selectedExpert && expertId !== selectedExpert) {
                    show = false;
                }

                // Фильтр по типу назначения
                if (selectedType === 'specific' && nominationCell && nominationCell.textContent.includes('Все номинации')) {
                    show = false;
                }
                if (selectedType === 'all_nominations' && nominationCell && !nominationCell.textContent.includes('Все номинации')) {
                    show = false;
                }
                if (selectedType === 'all_ages' && ageCell && !ageCell.textContent.includes('Все возрастные группы')) {
                    show = false;
                }

                row.style.display = show ? '' : 'none';
            });
        }

        // Привязываем фильтры к кнопке
        const applyFilterButton = document.querySelector('button.bg-blue-600:not([id])');
        if (applyFilterButton) {
            applyFilterButton.addEventListener('click', applyFilters);
        }

        const resetFilterButton = document.querySelector('button.border-gray-300:not([id])');
        if (resetFilterButton) {
            resetFilterButton.addEventListener('click', function() {
                if (expertSelect) expertSelect.value = '';
                if (contestSelect) contestSelect.value = '';
                if (typeSelect) typeSelect.value = '';
                tableRows.forEach(row => row.style.display = '');
            });
        }

        // Подтверждение удаления
        const deleteLinks = document.querySelectorAll('a[data-confirm]');
        deleteLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm(this.getAttribute('data-confirm'))) {
                    e.preventDefault();
                    return false;
                }

                // Проверка активного статуса
                const row = this.closest('tr');
                const statusCell = row.querySelector('.bg-green-100, .bg-yellow-100, .bg-gray-100');
                if (statusCell && statusCell.textContent.includes('Активен')) {
                    if (!confirm('Это назначение активно. Удаление может нарушить процесс оценки. Продолжить?')) {
                        e.preventDefault();
                        return false;
                    }
                }

                // Показать индикатор загрузки
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center"><svg class="animate-spin h-4 w-4 mr-1" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Удаление...</span>';
                this.classList.add('opacity-50');

                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('opacity-50');
                }, 2000);
            });
        });
    });
</script>