<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
?>

<!-- Основной контент -->
<div id="expert-assignment-create" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Назначение эксперта</h2>
            <p class="text-gray-600 mt-2">Назначьте эксперта для оценки заявок в конкурсе</p>
        </div>
        <?= Html::a('← Назад к назначениям', ['expert-assignments'], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная форма -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <div class="flex items-center mb-6">
                <div class="p-3 bg-blue-100 rounded-lg mr-4">
                    <span class="text-2xl text-blue-600">👨‍⚖️</span>
                </div>
                <div>
                    <h3 class="text-2xl font-bold text-gray-800">Новое назначение</h3>
                    <p class="text-gray-600">Заполните все необходимые поля</p>
                </div>
            </div>

            <?php $form = ActiveForm::begin([
                'id' => 'expert-assignment-form',
                'options' => ['class' => 'space-y-6']
            ]); ?>

            <!-- Эксперт -->
            <div>
                <?= $form->field($model, 'expert_id', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Выберите эксперта из списка</div>
                    '
                ])->dropDownList(
                    ArrayHelper::map($experts, 'id', fn($u) => $u->surname . ' ' . $u->name . ' (' . $u->email . ')'),
                    [
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                        'prompt' => 'Выберите эксперта',
                        'id' => 'expert-select'
                    ]
                )->label('👨‍⚖️ Эксперт *') ?>
            </div>

            <!-- Конкурс -->
            <div>
                <?= $form->field($model, 'contest_id', [
                    'template' => '
                        <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                        {input}
                        {error}
                        <div class="text-sm text-gray-500 mt-1">Выберите конкурс для оценки</div>
                    '
                ])->dropDownList(
                    ArrayHelper::map($contests, 'id', 'title'),
                    [
                        'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                        'prompt' => 'Выберите конкурс',
                        'id' => 'contest-select'
                    ]
                )->label('🏆 Конкурс *') ?>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Номинация -->
                <div>
                    <?= $form->field($model, 'nomination_id', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                            <div class="text-sm text-gray-500 mt-1">Оставьте пустым для всех номинаций</div>
                        '
                    ])->dropDownList(
                        ArrayHelper::map($nominations, 'id', 'name'),
                        [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                            'prompt' => 'Все номинации'
                        ]
                    )->label('🎯 Номинация') ?>
                </div>

                <!-- Возрастная категория -->
                <div>
                    <?= $form->field($model, 'age_category_id', [
                        'template' => '
                            <label class="block text-sm font-medium text-gray-700 mb-2">{label}</label>
                            {input}
                            {error}
                            <div class="text-sm text-gray-500 mt-1">Оставьте пустым для всех возрастных категорий</div>
                        '
                    ])->dropDownList(
                        ArrayHelper::map($categories, 'id', 'name'),
                        [
                            'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors appearance-none bg-white',
                            'prompt' => 'Все возрастные категории'
                        ]
                    )->label('👶 Возрастная категория') ?>
                </div>
            </div>



            <!-- Предварительный просмотр -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <h4 class="text-sm font-medium text-blue-700 mb-2">👁️ Предварительный просмотр</h4>
                <div id="assignment-preview" class="text-sm text-gray-600">
                    <div class="space-y-2">
                        <div class="flex items-center">
                            <div class="p-1 bg-blue-100 rounded mr-2">
                                <span class="text-blue-600 text-xs">👨‍⚖️</span>
                            </div>
                            <span id="preview-expert" class="text-gray-500">Эксперт не выбран</span>
                        </div>
                        <div class="flex items-center">
                            <div class="p-1 bg-green-100 rounded mr-2">
                                <span class="text-green-600 text-xs">🏆</span>
                            </div>
                            <span id="preview-contest" class="text-gray-500">Конкурс не выбран</span>
                        </div>
                        <div class="flex items-center">
                            <div class="p-1 bg-purple-100 rounded mr-2">
                                <span class="text-purple-600 text-xs">🎯</span>
                            </div>
                            <span id="preview-nomination" class="text-gray-500">Все номинации</span>
                        </div>
                        <div class="flex items-center">
                            <div class="p-1 bg-yellow-100 rounded mr-2">
                                <span class="text-yellow-600 text-xs">👶</span>
                            </div>
                            <span id="preview-age" class="text-gray-500">Все возрастные категории</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Кнопки -->
            <div class="mt-8 flex space-x-4">
                <?= Html::submitButton('👨‍⚖️ Назначить эксперта', [
                    'class' => 'flex-1 bg-blue-600 text-white py-3 px-6 rounded-lg hover:bg-blue-700 transition-colors font-medium',
                    'id' => 'submit-btn'
                ]) ?>

                <?= Html::a('Отмена', ['expert-assignments'], [
                    'class' => 'flex-1 border border-gray-300 text-gray-700 py-3 px-6 rounded-lg hover:bg-gray-50 transition-colors text-center font-medium'
                ]) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>


    </div>
</div>

<!-- Стили -->
<style>

    /* Кастомный селект */
    select {
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3E%3C/svg%3E");
        background-position: right 0.75rem center;
        background-repeat: no-repeat;
        background-size: 1.5em 1.5em;
        padding-right: 2.5rem;
    }

    /* Ошибки валидации */
    .has-error .form-control {
        border-color: #f87171;
        background-color: #fef2f2;
    }

    .has-error .help-block {
        color: #dc2626;
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }

    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .grid-cols-2 {
            grid-template-columns: 1fr;
        }

        .flex.space-x-4 {
            flex-direction: column;
            gap: 0.75rem;
        }

        .flex.space-x-4 > * {
            flex: none;
            width: 100%;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Элементы DOM
        const expertSelect = document.getElementById('expert-select');
        const contestSelect = document.getElementById('contest-select');
        const nominationSelect = document.querySelector('select[name="ExpertAssignment[nomination_id]"]');
        const ageSelect = document.querySelector('select[name="ExpertAssignment[age_category_id]"]');
        const submitBtn = document.getElementById('submit-btn');

        // Элементы предварительного просмотра
        const previewExpert = document.getElementById('preview-expert');
        const previewContest = document.getElementById('preview-contest');
        const previewNomination = document.getElementById('preview-nomination');
        const previewAge = document.getElementById('preview-age');

        // Данные экспертов (для предварительного просмотра)
        const expertsData = {
            <?php foreach ($experts as $expert): ?>
            '<?= $expert->id ?>': '<?= addslashes($expert->surname . ' ' . $expert->name) ?>',
            <?php endforeach; ?>
        };

        // Данные конкурсов
        const contestsData = {
            <?php foreach ($contests as $contest): ?>
            '<?= $contest->id ?>': '<?= addslashes($contest->title) ?>',
            <?php endforeach; ?>
        };

        // Данные номинаций
        const nominationsData = {
            '': 'Все номинации',
            <?php foreach ($nominations as $nomination): ?>
            '<?= $nomination->id ?>': '<?= addslashes($nomination->name) ?>',
            <?php endforeach; ?>
        };

        // Данные возрастных категорий
        const agesData = {
            '': 'Все возрастные категории',
            <?php foreach ($categories as $category): ?>
            '<?= $category->id ?>': '<?= addslashes($category->name) ?>',
            <?php endforeach; ?>
        };

        // Обновление предварительного просмотра
        function updatePreview() {
            // Эксперт
            if (expertSelect && expertSelect.value && expertsData[expertSelect.value]) {
                previewExpert.textContent = expertsData[expertSelect.value];
                previewExpert.classList.remove('text-gray-500');
                previewExpert.classList.add('text-gray-800', 'font-medium');
            } else {
                previewExpert.textContent = 'Эксперт не выбран';
                previewExpert.classList.remove('text-gray-800', 'font-medium');
                previewExpert.classList.add('text-gray-500');
            }

            // Конкурс
            if (contestSelect && contestSelect.value && contestsData[contestSelect.value]) {
                previewContest.textContent = contestsData[contestSelect.value];
                previewContest.classList.remove('text-gray-500');
                previewContest.classList.add('text-gray-800', 'font-medium');
            } else {
                previewContest.textContent = 'Конкурс не выбран';
                previewContest.classList.remove('text-gray-800', 'font-medium');
                previewContest.classList.add('text-gray-500');
            }

            // Номинация
            if (nominationSelect) {
                const value = nominationSelect.value;
                previewNomination.textContent = nominationsData[value] || 'Все номинации';
            }

            // Возрастная категория
            if (ageSelect) {
                const value = ageSelect.value;
                previewAge.textContent = agesData[value] || 'Все возрастные категории';
            }
        }

        // Обработчики событий
        if (expertSelect) {
            expertSelect.addEventListener('change', updatePreview);
        }

        if (contestSelect) {
            contestSelect.addEventListener('change', updatePreview);
        }

        if (nominationSelect) {
            nominationSelect.addEventListener('change', updatePreview);
        }

        if (ageSelect) {
            ageSelect.addEventListener('change', updatePreview);
        }

        // Валидация формы
        const form = document.getElementById('expert-assignment-form');
        if (form) {
            form.addEventListener('submit', function(e) {
                // Проверка обязательных полей
                if (!expertSelect || !expertSelect.value) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите эксперта');
                    expertSelect.focus();
                    expertSelect.classList.add('border-red-500');
                    return false;
                }

                if (!contestSelect || !contestSelect.value) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите конкурс');
                    contestSelect.focus();
                    contestSelect.classList.add('border-red-500');
                    return false;
                }

                // Проверка на дублирование назначения
                // Можно добавить AJAX проверку или предупреждение

                // Показать индикатор загрузки
                if (submitBtn) {
                    const originalText = submitBtn.innerHTML;
                    submitBtn.innerHTML = '<span class="flex items-center justify-center"><svg class="animate-spin h-5 w-5 mr-2 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Назначение...</span>';
                    submitBtn.disabled = true;

                    // Восстановление кнопки через 3 секунды (на случай если форма не отправится)
                    setTimeout(() => {
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }, 3000);
                }
            });
        }

        // Сброс ошибок при изменении
        if (expertSelect) {
            expertSelect.addEventListener('change', function() {
                this.classList.remove('border-red-500');
            });
        }

        if (contestSelect) {
            contestSelect.addEventListener('change', function() {
                this.classList.remove('border-red-500');
            });
        }

        // Автоматическое обновление выпадающих списков при выборе конкурса
        // (если нужно фильтровать номинации по конкурсу)
        if (contestSelect) {
            contestSelect.addEventListener('change', function() {
                const contestId = this.value;
                // Здесь можно добавить AJAX запрос для фильтрации номинаций по конкурсу
                // или показать/скрыть соответствующие опции
            });
        }

        // Инициализация предварительного просмотра
        updatePreview();
    });
</script>