<?php
use yii\helpers\Html;
use yii\grid\GridView;
?>

<!-- Основной контент -->
<div id="contest-view" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Просмотр конкурса</h2>
        </div>
        <?= Html::a('← Назад к конкурсам', ['contests'], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная информация -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <div class="flex items-center mb-6">
                <div class="p-3 bg-blue-100 rounded-lg mr-4">
                    <span class="text-2xl text-blue-600">🏆</span>
                </div>
                <div>
                    <h3 class="text-2xl font-bold text-gray-800"><?= Html::encode($model->title) ?></h3>
                    <p class="text-gray-600">Детальная информация о конкурсе</p>
                </div>
            </div>

            <!-- Статус конкурса -->
            <div class="mb-6">
                <?php
                $now = time();
                $startDate = strtotime($model->start_date);
                $endDate = strtotime($model->end_date);

                if ($now < $startDate) {
                    $status = 'Ожидает начала';
                    $statusClass = 'bg-yellow-100 text-yellow-800';
                    $statusIcon = '⏳';
                } elseif ($now > $endDate) {
                    $status = 'Завершен';
                    $statusClass = 'bg-gray-100 text-gray-800';
                    $statusIcon = '✅';
                } else {
                    $status = 'Активен';
                    $statusClass = 'bg-green-100 text-green-800';
                    $statusIcon = '🔥';
                }
                ?>
                <div class="inline-flex items-center px-4 py-2 <?= $statusClass ?> rounded-lg">
                    <span class="text-xl mr-2"><?= $statusIcon ?></span>
                    <span class="font-semibold"><?= $status ?></span>
                </div>
            </div>

            <!-- Детальная информация -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">📅 Дата начала</label>
                        <p class="text-lg font-semibold text-gray-800"><?= date('d.m.Y', $startDate) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">📅 Дата окончания</label>
                        <p class="text-lg font-semibold text-gray-800"><?= date('d.m.Y', $endDate) ?></p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">⏱️ Длительность</label>
                        <p class="text-lg font-semibold text-gray-800">
                            <?php
                            $days = ceil(($endDate - $startDate) / (60 * 60 * 24));
                            ?>
                        </p>
                    </div>
                </div>

                <div class="space-y-4">
                    <?php if (!empty($model->description)): ?>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">📝 Описание</label>
                            <p class="text-gray-600"><?= Html::encode($model->description) ?></p>
                        </div>
                    <?php endif; ?>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">📊 Статистика</label>
                        <div class="flex space-x-4">
                            <div class="text-center">
                                <div class="text-xl font-bold text-blue-600"><?= $model->getApplications()->count() ?></div>
                                <div class="text-xs text-gray-500">Заявок</div>
                            </div>
                            <div class="text-center">
                                <div class="text-xl font-bold text-green-600">
                                    <?= $model->getApplications()->andWhere(['status' => 'accepted'])->count() ?>
                                </div>
                                <div class="text-xs text-gray-500">Принято</div>
                            </div>
                            <div class="text-center">
                                <div class="text-xl font-bold text-purple-600">
                                    <?php
                                    $uniqueNominations = [];
                                    foreach ($model->applications as $app) {
                                        if ($app->nomination_id) {
                                            $uniqueNominations[$app->nomination_id] = true;
                                        }
                                    }
                                    echo count($uniqueNominations);
                                    ?>
                                </div>
                                <div class="text-xs text-gray-500">Номинаций</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Основные действия -->
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                <h4 class="text-sm font-medium text-blue-700 mb-3">⚡ Основные действия</h4>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    <?= Html::a('✏️ Редактировать', ['contest-update', 'id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-blue-300 text-blue-700 rounded-lg hover:bg-blue-50 transition-colors text-sm'
                    ]) ?>

                    <?= Html::a('📋 Заявки', ['applications', 'ApplicationSearch[contest_id]' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-green-300 text-green-700 rounded-lg hover:bg-green-50 transition-colors text-sm'
                    ]) ?>

                    <?= Html::a('👨‍⚖️ Эксперты', ['expert-assignments', 'ExpertAssignmentSearch[contest_id]' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-purple-300 text-purple-700 rounded-lg hover:bg-purple-50 transition-colors text-sm'
                    ]) ?>

                    <?= Html::a('📊 Оценки', ['evaluations', 'EvaluationSearch[contest_id]' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-yellow-300 text-yellow-700 rounded-lg hover:bg-yellow-50 transition-colors text-sm'
                    ]) ?>
                </div>
            </div>

            <!-- Экспорт и документы -->
            <div class="bg-white border border-gray-200 rounded-lg p-4 mb-6">
                <h4 class="text-sm font-medium text-gray-700 mb-3">📁 Экспорт и документы</h4>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    <?= Html::a('📄 Программа', ['download-program', 'contest_id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-blue-50 border border-blue-200 text-blue-700 rounded-lg hover:bg-blue-100 transition-colors text-sm flex flex-col items-center'
                    ]) ?>

                    <?= Html::a('📊 Оценки', ['download-evaluations', 'contest_id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-green-50 border border-green-200 text-green-700 rounded-lg hover:bg-green-100 transition-colors text-sm flex flex-col items-center'
                    ]) ?>

                    <?= Html::a('📋 Протокол', ['protocol/generate-protocol', 'contest_id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-purple-50 border border-purple-200 text-purple-700 rounded-lg hover:bg-purple-100 transition-colors text-sm flex flex-col items-center'
                    ]) ?>

                    <?= Html::a('🏅 Дипломы ZIP', ['protocol/generate-diplomas', 'contest_id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-yellow-50 border border-yellow-200 text-yellow-700 rounded-lg hover:bg-yellow-100 transition-colors text-sm flex flex-col items-center'
                    ]) ?>
                </div>
            </div>

            <!-- Опасные действия -->
            <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                <h4 class="text-sm font-medium text-red-700 mb-3">⚠️ Опасные действия</h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    <?= Html::a('🗑️ Удалить все файлы заявок', ['delete-files', 'contest_id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-red-300 text-red-700 rounded-lg hover:bg-red-50 transition-colors text-sm',
                        'data' => [
                            'confirm' => 'ВНИМАНИЕ! Вы уверены, что хотите удалить ВСЕ файлы заявок этого конкурса? Это действие невозможно отменить.'
                        ]
                    ]) ?>

                    <?= Html::a('🗑️ Удалить конкурс', ['contest-delete', 'id' => $model->id], [
                        'class' => 'text-center py-2 px-3 bg-white border border-red-300 text-red-700 rounded-lg hover:bg-red-50 transition-colors text-sm',
                        'data' => [
                            'confirm' => 'ВНИМАНИЕ! Вы уверены, что хотите удалить этот конкурс? Будут удалены все связанные заявки, оценки и файлы. Это действие невозможно отменить.'
                        ]
                    ]) ?>
                </div>
            </div>
        </div>






    </div>


</div>

<!-- Стили -->
<style>


    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        table {
            min-width: 1000px;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }

        .grid-cols-2, .grid-cols-4 {
            grid-template-columns: 1fr;
        }

        .flex.space-x-2 {
            flex-wrap: wrap;
            gap: 0.5rem;
        }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Фильтрация заявок
        const filterButtons = document.querySelectorAll('.flex.space-x-2 button');
        const tableRows = document.querySelectorAll('tbody tr');

        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                const filterType = this.textContent.trim();

                // Сбрасываем активный класс у всех кнопок
                filterButtons.forEach(btn => {
                    btn.classList.remove('bg-blue-600', 'text-white');
                    btn.classList.add('border', 'border-gray-300', 'text-gray-700');
                });

                // Активируем текущую кнопку
                this.classList.remove('border', 'border-gray-300', 'text-gray-700');
                this.classList.add('bg-blue-600', 'text-white');

                // Применяем фильтр
                const statusMap = {
                    'Все': '',
                    'Новые': 'new',
                    'Принятые': 'accepted',
                    'Заблокированные': 'blocked'
                };

                const targetStatus = statusMap[filterType];

                tableRows.forEach(row => {
                    const statusCell = row.querySelector('.px-3.py-1');
                    const statusText = statusCell ? statusCell.textContent.toLowerCase() : '';

                    if (!targetStatus || statusText.includes(targetStatus)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        });

        // Подтверждение опасных действий
        const dangerousLinks = document.querySelectorAll('a[data-confirm]');
        dangerousLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                if (!confirm(this.getAttribute('data-confirm'))) {
                    e.preventDefault();
                    return false;
                }

                // Дополнительная проверка для удаления файлов
                if (this.textContent.includes('файлы заявок')) {
                    const applicationsCount = <?= $model->getApplications()->count() ?>;
                    if (applicationsCount > 0) {
                        if (!confirm(`В конкурсе ${applicationsCount} заявок. ВСЕ файлы будут удалены безвозвратно. Продолжить?`)) {
                            e.preventDefault();
                            return false;
                        }
                    }
                }

                // Показать индикатор загрузки
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center justify-center"><svg class="animate-spin h-4 w-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Выполнение...</span>';
                this.classList.add('opacity-50');

                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('opacity-50');
                }, 3000);
            });
        });

        // Загрузка документов
        const documentLinks = document.querySelectorAll('a[href*="download"], a[href*="generate"]');
        documentLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const originalHTML = this.innerHTML;
                this.innerHTML = '<span class="flex items-center justify-center"><svg class="animate-spin h-4 w-4 mr-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> Генерация...</span>';
                this.classList.add('opacity-50');

                setTimeout(() => {
                    this.innerHTML = originalHTML;
                    this.classList.remove('opacity-50');
                }, 5000);
            });
        });

        // Подсветка статусов
        tableRows.forEach(row => {
            const statusCell = row.querySelector('.px-3.py-1');
            if (statusCell) {
                if (statusCell.textContent.includes('new')) {
                    row.classList.add('bg-gradient-to-r', 'from-yellow-50', 'to-transparent');
                } else if (statusCell.textContent.includes('blocked')) {
                    row.classList.add('bg-gradient-to-r', 'from-red-50', 'to-transparent');
                }
            }
        });
    });
</script>