<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model app\models\Contest */
/* @var $nominations app\models\Nomination[] */
/* @var $categories app\models\AgeCategory[] */

$this->title = 'Редактировать конкурс: ' . Html::encode($model->title);
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>

    <div class="flex items-center space-x-4">
        <!-- Статус конкурса -->
        <?php
        $now = time();
        $start = strtotime($model->start_date);
        $end = strtotime($model->end_date);


        ?>


        <?= Html::a('← Назад к списку', ['contests/index'], [
            'class' => 'text-blue-600 hover:text-blue-800 font-medium'
        ]) ?>
    </div>
</div>

<!-- Если конкурс активен или завершён -->


<!-- Основная форма -->
<div class="bg-white rounded-xl shadow-md p-6">
    <?php $form = ActiveForm::begin([
        'id' => 'contest-edit-form',
        'options' => ['class' => 'space-y-6']
    ]); ?>

    <!-- Шаг 1: Основная информация -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">1️⃣</span> Основная информация
        </h3>

        <!-- Название конкурса -->
        <?= $form->field($model, 'title', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Введите название конкурса',
            ]
        ])->label('Название конкурса *') ?>


        <!-- Описание конкурса -->
        <?= $form->field($model, 'description', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Введите описание конкурса',
            ]
        ])->label('Описание конкурса *') ?>



    </div>

    <!-- Шаг 2: Даты проведения -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">2️⃣</span> Даты проведения
        </h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Дата начала -->
            <?= $form->field($model, 'start_date', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'type' => 'date',
                    'readonly' => $now >= $start
                ]
            ])->label('Дата начала *') ?>

            <!-- Дата окончания -->
            <?= $form->field($model, 'end_date', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'type' => 'date',
                    'readonly' => $now > $end
                ]
            ])->label('Дата окончания *') ?>
        </div>

        <!-- Информация о датах -->
        <?php if ($now >= $start): ?>
            <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                <p class="text-sm text-blue-700">
                    <?php if ($now >= $start && $now <= $end): ?>
                        ⚠️ Конкурс уже начался. Дата начала не может быть изменена.
                        <?php if ($now > strtotime($model->start_date)): ?>
                            Конкурс начался <?= date('d.m.Y', $start) ?>.
                        <?php endif; ?>
                    <?php elseif ($now > $end): ?>
                        ⚠️ Конкурс завершён <?= date('d.m.Y', $end) ?>. Даты проведения не могут быть изменены.
                    <?php endif; ?>
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Шаг 3: Номинации -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">3️⃣</span> Номинации конкурса
        </h3>

        <div class="mb-2">
            <label class="block text-sm font-medium text-gray-700 mb-3">
                Выберите номинации, которые будут доступны в этом конкурсе
            </label>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                <?php foreach ($nominations as $nomination):
                    $isSelected = in_array($nomination->id, ArrayHelper::getColumn($model->nominations, 'id'));
                    $hasApplications = false;

                    // Проверяем, есть ли заявки в этой номинации
                    if ($now >= $start) {
                        $hasApplications = $model->getApplications()
                            ->where(['nomination_id' => $nomination->id])
                            ->exists();
                    }
                    ?>
                    <div class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors
                        <?= $hasApplications ? 'bg-yellow-50 border-yellow-200' : '' ?>">
                        <input type="checkbox"
                               name="nominations[]"
                               value="<?= $nomination->id ?>"
                               id="nomination-<?= $nomination->id ?>"
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                            <?= $isSelected ? 'checked' : '' ?>
                            <?= $hasApplications ? 'disabled' : '' ?>>

                        <label for="nomination-<?= $nomination->id ?>" class="ml-3 flex-1 cursor-pointer">
                            <div class="flex items-center justify-between">
                                <span class="font-medium text-gray-800"><?= Html::encode($nomination->name) ?></span>
                                <?php if ($hasApplications): ?>
                                    <span class="text-xs bg-yellow-100 text-yellow-800 px-2 py-1 rounded">Есть заявки</span>
                                <?php endif; ?>
                            </div>

                        </label>
                    </div>
                <?php endforeach; ?>

                <?php if (empty($nominations)): ?>
                    <div class="col-span-full p-4 bg-gray-50 rounded-lg text-center">
                        <p class="text-gray-500">Номинации не созданы</p>
                        <?= Html::a('Создать номинацию', ['nominations/create'], [
                            'class' => 'inline-block mt-2 text-blue-600 hover:text-blue-800 text-sm'
                        ]) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php if ($now >= $start): ?>
            <div class="mt-3 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                <p class="text-sm text-yellow-700">
                    ⚠️ Номинации с уже поданными заявками не могут быть отключены
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Шаг 4: Возрастные категории -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">4️⃣</span> Возрастные категории
        </h3>

        <div class="mb-2">
            <label class="block text-sm font-medium text-gray-700 mb-3">
                Выберите возрастные категории для участия в конкурсе
            </label>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                <?php foreach ($categories as $category):
                    $isSelected = in_array($category->id, ArrayHelper::getColumn($model->ageCategories, 'id'));
                    $hasApplications = false;

                    // Проверяем, есть ли заявки в этой категории
                    if ($now >= $start) {
                        $hasApplications = $model->getApplications()
                            ->where(['age_category_id' => $category->id])
                            ->exists();
                    }
                    ?>
                    <div class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors
                        <?= $hasApplications ? 'bg-yellow-50 border-yellow-200' : '' ?>">
                        <input type="checkbox"
                               name="categories[]"
                               value="<?= $category->id ?>"
                               id="category-<?= $category->id ?>"
                               class="h-4 w-4 text-green-600 border-gray-300 rounded focus:ring-green-500"
                            <?= $isSelected ? 'checked' : '' ?>
                            <?= $hasApplications ? 'disabled' : '' ?>>

                        <label for="category-<?= $category->id ?>" class="ml-3 flex-1 cursor-pointer">
                            <div class="flex items-center justify-between">
                                <span class="font-medium text-gray-800"><?= Html::encode($category->name) ?></span>
                                <?php if ($hasApplications): ?>
                                    <span class="text-xs bg-yellow-100 text-yellow-800 px-2 py-1 rounded">Есть заявки</span>
                                <?php endif; ?>
                            </div>

                        </label>
                    </div>
                <?php endforeach; ?>

                <?php if (empty($categories)): ?>
                    <div class="col-span-full p-4 bg-gray-50 rounded-lg text-center">
                        <p class="text-gray-500">Возрастные категории не созданы</p>
                        <?= Html::a('Создать категорию', ['age-categories/create'], [
                            'class' => 'inline-block mt-2 text-blue-600 hover:text-blue-800 text-sm'
                        ]) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php if ($now >= $start): ?>
            <div class="mt-3 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                <p class="text-sm text-yellow-700">
                    ⚠️ Возрастные категории с уже поданными заявками не могут быть отключены
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Шаг 5: Статус конкурса -->
    <div class="pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">5️⃣</span> Статус конкурса
        </h3>

        <div class="space-y-4">
            <!-- Статус -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Статус конкурса</label>
                <p class="text-xs text-gray-500 mt-1">
                    <?php if ($now >= $start): ?>
                        Статус нельзя изменить после начала конкурса
                    <?php else: ?>
                        Определяет видимость конкурса для участников
                    <?php endif; ?>
                </p>
            </div>

            <!-- Дополнительная информация -->
            <div class="bg-gray-50 rounded-lg p-4">
                <h4 class="font-medium text-gray-800 mb-2">Информация о конкурсе</h4>
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <p class="text-gray-600">Дата создания:</p>
                        <p class="font-medium text-gray-800"><?= date('d.m.Y', strtotime($model->created_at)) ?></p>
                    </div>
                    <div>
                        <p class="text-gray-600">Последнее обновление:</p>
                        <p class="font-medium text-gray-800"><?= date('d.m.Y', strtotime($model->updated_at)) ?></p>
                    </div>
                    <?php if ($now >= $start): ?>
                        <div class="col-span-2">
                            <p class="text-gray-600">Заявок подано:</p>
                            <p class="font-medium text-gray-800"><?= $model->getApplications()->count() ?> заявок</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Кнопки действий -->
    <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
        <?= Html::submitButton('💾 Сохранить изменения', [
            'class' => 'flex-1 bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 transition-colors font-medium'
        ]) ?>






    </div>

    <?php ActiveForm::end(); ?>
</div>

<!-- JavaScript для валидации -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('contest-edit-form');
        const now = new Date();

        if (form) {
            form.addEventListener('submit', function(e) {
                // Проверка обязательных полей
                const title = document.querySelector('[name="Contest[title]"]')?.value;

                const startDate = document.querySelector('[name="Contest[start_date]"]')?.value;
                const endDate = document.querySelector('[name="Contest[end_date]"]')?.value;

                if (!title || !title.trim()) {
                    e.preventDefault();
                    alert('Пожалуйста, введите название конкурса');
                    document.querySelector('[name="Contest[title]"]')?.focus();
                    return;
                }

                if (!description || !description.trim()) {
                    e.preventDefault();
                    alert('Пожалуйста, введите описание конкурса');
                    document.querySelector('[name="Contest[description]"]')?.focus();
                    return;
                }

                if (!startDate) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите дату начала конкурса');
                    return;
                }

                if (!endDate) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите дату окончания конкурса');
                    return;
                }

                // Проверка дат
                const start = new Date(startDate);
                const end = new Date(endDate);

                if (end < start) {
                    e.preventDefault();
                    alert('Дата окончания не может быть раньше даты начала');
                    return;
                }

                // Проверка, не пытаемся ли изменить дату начала после начала конкурса
                const originalStart = new Date('<?= $model->start_date ?>');
                if (start.getTime() !== originalStart.getTime() && now >= originalStart) {
                    e.preventDefault();
                    alert('Нельзя изменять дату начала после начала конкурса');
                    return;
                }

                // Проверка, не пытаемся ли изменить дату окончания раньше текущей даты
                if (end < now && now > originalStart) {
                    e.preventDefault();
                    alert('Дата окончания не может быть раньше текущей даты');
                    return;
                }

                // Предупреждение об изменении номинаций/категорий после начала
                const selectedNominations = document.querySelectorAll('input[name="nominations[]"]:checked:not(:disabled)').length;
                const selectedCategories = document.querySelectorAll('input[name="categories[]"]:checked:not(:disabled)').length;

                if (now >= originalStart && (selectedNominations === 0 || selectedCategories === 0)) {
                    if (!confirm('Вы собираетесь отключить все доступные номинации или возрастные категории. Это может повлиять на новые заявки. Продолжить?')) {
                        e.preventDefault();
                        return;
                    }
                }

                // Подтверждение публикации
                if (e.submitter && e.submitter.name === 'publish') {
                    if (!confirm('Вы уверены, что хотите опубликовать конкурс? После публикации некоторые параметры нельзя будет изменить.')) {
                        e.preventDefault();
                        return;
                    }
                }
            });
        }
    });
</script>