<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model app\models\Contest */
/* @var $nominations app\models\Nomination[] */
/* @var $categories app\models\AgeCategory[] */

$this->title = 'Создать конкурс';
?>

<!-- Заголовок в стиле дизайн-проекта -->
<div class="flex justify-between items-center mb-8">
    <h2 class="text-3xl font-bold text-gray-800"><?= Html::encode($this->title) ?></h2>

    <?= Html::a('← Назад к списку', ['contests/index'], [
        'class' => 'text-blue-600 hover:text-blue-800 font-medium'
    ]) ?>
</div>

<!-- Основная форма -->
<div class="bg-white rounded-xl shadow-md p-6">
    <?php $form = ActiveForm::begin([
        'id' => 'contest-form',
        'options' => ['class' => 'space-y-6']
    ]); ?>

    <!-- Шаг 1: Основная информация -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">1️⃣</span> Основная информация
        </h3>

        <!-- Название конкурса -->
        <?= $form->field($model, 'title', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Введите название конкурса'
            ]
        ])->label('Название конкурса *') ?>

        <!-- Описание конкурса -->
        <?= $form->field($model, 'description', [
            'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
            'inputOptions' => [
                'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                'placeholder' => 'Введите описание конкурса'
            ]
        ])->label('Описание конкурса *') ?>
    </div>

    <!-- Шаг 2: Даты проведения -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">2️⃣</span> Даты проведения
        </h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Дата начала -->
            <?= $form->field($model, 'start_date', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'type' => 'date'
                ]
            ])->label('Дата начала *') ?>

            <!-- Дата окончания -->
            <?= $form->field($model, 'end_date', [
                'labelOptions' => ['class' => 'block text-sm font-medium text-gray-700 mb-1'],
                'inputOptions' => [
                    'class' => 'w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500',
                    'type' => 'date'
                ]
            ])->label('Дата окончания *') ?>
        </div>


    </div>

    <!-- Шаг 3: Номинации -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">3️⃣</span> Номинации конкурса
        </h3>

        <div class="mb-2">
            <label class="block text-sm font-medium text-gray-700 mb-3">
                Выберите номинации, которые будут доступны в этом конкурсе
            </label>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                <?php foreach ($nominations as $nomination): ?>
                    <div class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                        <input type="checkbox"
                               name="nominations[]"
                               value="<?= $nomination->id ?>"
                               id="nomination-<?= $nomination->id ?>"
                               class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                            <?= in_array($nomination->id, ArrayHelper::getColumn($model->nominations, 'id')) ? 'checked' : '' ?>>

                        <label for="nomination-<?= $nomination->id ?>" class="ml-3 flex-1 cursor-pointer">
                            <span class="font-medium text-gray-800"><?= Html::encode($nomination->name) ?></span>

                        </label>
                    </div>
                <?php endforeach; ?>

                <?php if (empty($nominations)): ?>
                    <div class="col-span-full p-4 bg-gray-50 rounded-lg text-center">
                        <p class="text-gray-500">Номинации не созданы</p>
                        <?= Html::a('Создать номинацию', ['nominations/create'], [
                            'class' => 'inline-block mt-2 text-blue-600 hover:text-blue-800 text-sm'
                        ]) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>

    <!-- Шаг 4: Возрастные категории -->
    <div class="border-b border-gray-200 pb-6">
        <h3 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
            <span class="mr-2">4️⃣</span> Возрастные категории
        </h3>

        <div class="mb-2">
            <label class="block text-sm font-medium text-gray-700 mb-3">
                Выберите возрастные категории для участия в конкурсе
            </label>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">
                <?php foreach ($categories as $category): ?>
                    <div class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                        <input type="checkbox"
                               name="categories[]"
                               value="<?= $category->id ?>"
                               id="category-<?= $category->id ?>"
                               class="h-4 w-4 text-green-600 border-gray-300 rounded focus:ring-green-500"
                            <?= in_array($category->id, ArrayHelper::getColumn($model->ageCategories, 'id')) ? 'checked' : '' ?>>

                        <label for="category-<?= $category->id ?>" class="ml-3 flex-1 cursor-pointer">
                            <span class="font-medium text-gray-800"><?= Html::encode($category->name) ?></span>

                        </label>
                    </div>
                <?php endforeach; ?>

                <?php if (empty($categories)): ?>
                    <div class="col-span-full p-4 bg-gray-50 rounded-lg text-center">
                        <p class="text-gray-500">Возрастные категории не созданы</p>
                        <?= Html::a('Создать категорию', ['age-categories/create'], [
                            'class' => 'inline-block mt-2 text-blue-600 hover:text-blue-800 text-sm'
                        ]) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </div>


    <!-- Кнопки действий -->
    <div class="mt-8 flex space-x-4 pt-6 border-t border-gray-200">
        <?= Html::submitButton('✅ Сохранить конкурс', [
            'class' => 'flex-1 bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 transition-colors font-medium'
        ]) ?>

    </div>

    <?php ActiveForm::end(); ?>
</div>

<!-- JavaScript для быстрого добавления номинаций и категорий -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Быстрое добавление номинации
        const nominationInput = document.getElementById('new-nomination-input');
        const addNominationBtn = document.getElementById('add-nomination-btn');
        const nominationsContainer = document.querySelector('.grid-cols-3');

        if (addNominationBtn && nominationInput) {
            addNominationBtn.addEventListener('click', function() {
                const nominationName = nominationInput.value.trim();

                if (!nominationName) {
                    alert('Введите название номинации');
                    return;
                }

                // Здесь можно отправить AJAX запрос для создания номинации
                // В демо-режиме просто добавим визуально
                const newId = Date.now(); // Временный ID

                // Создаем новый элемент номинации
                const newNomination = document.createElement('div');
                newNomination.className = 'flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors';
                newNomination.innerHTML = `
                <input type="checkbox"
                       name="nominations[]"
                       value="${newId}"
                       id="nomination-${newId}"
                       class="h-4 w-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                       checked>

                <label for="nomination-${newId}" class="ml-3 flex-1 cursor-pointer">
                    <span class="font-medium text-gray-800">${nominationName}</span>
                    <p class="text-xs text-gray-500 mt-1">Новая номинация</p>
                </label>
            `;

                // Добавляем в контейнер
                if (nominationsContainer) {
                    nominationsContainer.appendChild(newNomination);
                } else {
                    // Если нет контейнера, создаем его
                    const container = document.querySelector('.grid-cols-3') ||
                        document.querySelector('.grid-cols-2') ||
                        document.querySelector('.grid-cols-1');
                    if (container) {
                        container.appendChild(newNomination);
                    }
                }

                // Очищаем поле ввода
                nominationInput.value = '';

                // Показываем уведомление
                alert('Номинация добавлена (в реальной системе будет отправлен запрос на сервер)');
            });
        }

        // Быстрое добавление возрастной категории
        const categoryInput = document.getElementById('new-category-input');
        const addCategoryBtn = document.getElementById('add-category-btn');

        if (addCategoryBtn && categoryInput) {
            addCategoryBtn.addEventListener('click', function() {
                const categoryName = categoryInput.value.trim();

                if (!categoryName) {
                    alert('Введите название возрастной категории');
                    return;
                }

                // Аналогично номинациям
                const newId = Date.now();

                const newCategory = document.createElement('div');
                newCategory.className = 'flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors';
                newCategory.innerHTML = `
                <input type="checkbox"
                       name="categories[]"
                       value="${newId}"
                       id="category-${newId}"
                       class="h-4 w-4 text-green-600 border-gray-300 rounded focus:ring-green-500"
                       checked>

                <label for="category-${newId}" class="ml-3 flex-1 cursor-pointer">
                    <span class="font-medium text-gray-800">${categoryName}</span>
                    <p class="text-xs text-gray-500 mt-1">Новая возрастная категория</p>
                </label>
            `;

                // Находим контейнер категорий
                const categoryContainer = document.querySelectorAll('.grid-cols-3')[1] ||
                    document.querySelectorAll('.grid-cols-2')[1] ||
                    document.querySelectorAll('.grid-cols-1')[1];

                if (categoryContainer) {
                    categoryContainer.appendChild(newCategory);
                }

                categoryInput.value = '';
                alert('Возрастная категория добавлена (в реальной системе будет отправлен запрос на сервер)');
            });
        }

        // Валидация формы
        const form = document.getElementById('contest-form');
        if (form) {
            form.addEventListener('submit', function(e) {
                // Проверка обязательных полей
                const title = document.getElementById('contest-title')?.value;

                const startDate = document.querySelector('[name="Contest[start_date]"]')?.value;
                const endDate = document.querySelector('[name="Contest[end_date]"]')?.value;

                if (!title || !title.trim()) {
                    e.preventDefault();
                    alert('Пожалуйста, введите название конкурса');
                    document.getElementById('contest-title')?.focus();
                    return;
                }



                if (!startDate) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите дату начала конкурса');
                    return;
                }

                if (!endDate) {
                    e.preventDefault();
                    alert('Пожалуйста, выберите дату окончания конкурса');
                    return;
                }

                // Проверка дат
                const start = new Date(startDate);
                const end = new Date(endDate);
                const today = new Date();
                today.setHours(0, 0, 0, 0);

                if (end < start) {
                    e.preventDefault();
                    alert('Дата окончания не может быть раньше даты начала');
                    return;
                }

                if (end < today) {
                    if (!confirm('Дата окончания конкурса уже прошла. Вы уверены, что хотите создать конкурс с завершённой датой?')) {
                        e.preventDefault();
                        return;
                    }
                }

                // Проверка выбранных номинаций
                const selectedNominations = document.querySelectorAll('input[name="nominations[]"]:checked').length;
                if (selectedNominations === 0) {
                    if (!confirm('Вы не выбрали ни одной номинации. Конкурс будет создан без номинаций. Продолжить?')) {
                        e.preventDefault();
                        return;
                    }
                }

                // Проверка выбранных категорий
                const selectedCategories = document.querySelectorAll('input[name="categories[]"]:checked').length;
                if (selectedCategories === 0) {
                    if (!confirm('Вы не выбрали ни одной возрастной категории. Конкурс будет создан без возрастных ограничений. Продолжить?')) {
                        e.preventDefault();
                        return;
                    }
                }
            });
        }
    });
</script>