<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
?>

<h1 class="text-2xl font-bold mb-4">Назначить эксперта</h1>

<?php $form = ActiveForm::begin(); ?>

<?= $form->field($model,'expert_id')->dropDownList(
    ArrayHelper::map($experts,'id','surname')
) ?>

<?= $form->field($model,'contest_id')->dropDownList(
    ArrayHelper::map($contests,'id','title')
) ?>

<?= $form->field($model,'nomination_id')->dropDownList(
    ArrayHelper::map($nominations,'id','name')
) ?>

<?= $form->field($model,'age_category_id')->dropDownList(
    ArrayHelper::map($categories,'id','name')
) ?>

<div class="mt-4">
    <?= Html::submitButton('Назначить', ['class'=>'bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600']) ?>
    <?= Html::a('Назад', ['expert-assignments'], ['class'=>'ml-2 text-gray-600']) ?>
</div>

<?php ActiveForm::end(); ?>
