<?php
use yii\helpers\Html;
use yii\widgets\DetailView;
?>

<!-- Основной контент -->
<div id="application-view" class="page">
    <div class="flex justify-between items-center mb-8">
        <div>
            <h2 class="text-3xl font-bold text-gray-800">Просмотр заявки</h2>
            <p class="text-gray-600 mt-2">ID: <span class="font-semibold">#<?= $model->id ?></span></p>
        </div>
        <?= Html::a('Назад к списку', ['index'], [
            'class' => 'text-blue-600 hover:text-blue-800 flex items-center'
        ]) ?>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Основная информация -->
        <div class="bg-white rounded-xl shadow-md p-6 lg:col-span-2">
            <h3 class="text-2xl font-bold text-gray-800 mb-6">📄 Информация о заявке</h3>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Блок участника -->
                <div class="space-y-4">
                    <div class="bg-blue-50 border border-blue-100 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-blue-800 mb-3">👤 Участник</h4>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Фамилия:</span>
                                <span class="font-medium"><?= Html::encode($model->user->surname) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Имя:</span>
                                <span class="font-medium"><?= Html::encode($model->user->name) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Email:</span>
                                <span class="font-medium"><?= Html::encode($model->user->email) ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Название работы -->
                    <div class="bg-white border border-gray-200 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-gray-800 mb-3">🏆 Название работы</h4>
                        <p class="text-xl font-bold text-gray-900"><?= Html::encode($model->title) ?></p>
                    </div>
                </div>

                <!-- Блок конкурса -->
                <div class="space-y-4">
                    <div class="bg-purple-50 border border-purple-100 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-purple-800 mb-3">🎯 Конкурс</h4>
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Название:</span>
                                <span class="font-medium"><?= Html::encode($model->contest->title) ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Даты проведения:</span>
                                <span class="font-medium">
                                    <?= date('d.m.Y', strtotime($model->contest->start_date)) ?> -
                                    <?= date('d.m.Y', strtotime($model->contest->end_date)) ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <!-- Номинация и категория -->
                    <div class="bg-green-50 border border-green-100 rounded-lg p-4">
                        <h4 class="text-lg font-semibold text-green-800 mb-3">📊 Категории</h4>
                        <div class="space-y-2">
                            <div class="flex items-center">
                                <span class="text-gray-600 mr-2">Номинация:</span>
                                <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm font-medium">
                                    <?= Html::encode($model->nomination->name) ?>
                                </span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-gray-600 mr-2">Возрастная категория:</span>
                                <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-sm font-medium">
                                    <?= Html::encode($model->ageCategory->name) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Дополнительная информация -->
            <div class="mt-6 bg-gray-50 border border-gray-200 rounded-lg p-6">
                <h4 class="text-lg font-semibold text-gray-800 mb-4">📋 Дополнительные данные</h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Учреждение:</span>
                        <span class="font-medium"><?= Html::encode($model->institution ?? 'не указано') ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Руководитель:</span>
                        <span class="font-medium"><?= Html::encode($model->leader ?? 'не указан') ?></span>
                    </div>
                </div>
            </div>

            <!-- Файлы -->
            <?php if ($model->file_path): ?>
                <div class="mt-6 bg-yellow-50 border border-yellow-100 rounded-lg p-6">
                    <h4 class="text-lg font-semibold text-yellow-800 mb-4">📎 Прикрепленные файлы</h4>
                    <div class="flex items-center space-x-4">
                        <div class="flex items-center">
                            <svg class="w-8 h-8 text-yellow-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4z" clip-rule="evenodd"/>
                            </svg>

                        </div>
                        <?= Html::a('Скачать', Yii::getAlias('@web') . $model->file_path, [
                            'class' => 'bg-yellow-500 text-white px-4 py-2 rounded-lg hover:bg-yellow-600 transition-colors',
                            'target' => '_blank',
                            'download' => true
                        ]) ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Боковая панель -->
        <div class="space-y-6">
            <!-- Статус -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h4 class="text-lg font-semibold text-gray-800 mb-4">📊 Статус заявки</h4>

                <div class="space-y-3 text-sm text-gray-600">
                    <div class="flex justify-between">
                        <span>Статус:</span>
                        <span class="font-medium"><?= ($model->status ?? 'NULL') ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Создана:</span>
                        <span class="font-medium"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></span>
                    </div>
                </div>
            </div>

            <!-- Действия -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h4 class="text-lg font-semibold text-gray-800 mb-4">⚡ Изменить статус</h4>
                <div class="space-y-3">


                    <?php if ($model->status !== 'blocked'): ?>
                        <?= Html::a('🚫 Заблокировать', ['/admin/block-application', 'id' => $model->id], [
                            'class' => 'block w-full text-center py-3 px-4 bg-red-50 border border-red-300 text-red-700 rounded-lg hover:bg-red-100 transition-colors font-medium',
                            'data' => ['confirm' => 'Вы уверены, что хотите заблокировать заявку?']
                        ]) ?>
                    <?php else: ?>
                        <?= Html::a('✅ Разблокировать', ['/admin/unblock-application', 'id' => $model->id], [
                            'class' => 'block w-full text-center py-3 px-4 bg-green-50 border border-green-300 text-green-700 rounded-lg hover:bg-green-100 transition-colors font-medium',
                            'data' => ['confirm' => 'Разблокировать заявку?']
                        ]) ?>
                    <?php endif; ?>

                </div>
            </div>


        </div>
    </div>
</div>

<!-- Стили -->
<style>


    /* Адаптивность */
    @media (max-width: 1024px) {
        .lg\:grid-cols-3 {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .grid-cols-2 {
            grid-template-columns: 1fr;
        }

        .flex.justify-between {
            flex-direction: column;
            gap: 1rem;
        }
    }
</style>

<script>
    // Подтверждение действий
    document.addEventListener('DOMContentLoaded', function() {
        const confirmButtons = document.querySelectorAll('[data-confirm]');
        confirmButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                if (!confirm(this.getAttribute('data-confirm'))) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                }
            });
        });

        // Подсветка текущего статуса
        const currentStatus = '<?= $model->status ?>';
        const statusButtons = document.querySelectorAll('.bg-white.rounded-xl.shadow-md.p-6:first-child a');

        statusButtons.forEach(button => {
            const statusText = button.textContent.toLowerCase();
            if (statusText.includes(currentStatus)) {
                button.classList.add('opacity-50', 'cursor-not-allowed');
                button.classList.remove('hover:bg-yellow-100', 'hover:bg-green-100', 'hover:bg-red-100');
                button.onclick = function(e) { e.preventDefault(); };
            }
        });

        // Анимация загрузки файла
        const downloadButton = document.querySelector('a[download]');
        if (downloadButton) {
            downloadButton.addEventListener('click', function() {
                const originalText = this.innerHTML;
                this.innerHTML = '<span class="flex items-center justify-center">📥 Загрузка...</span>';
                this.classList.add('opacity-75');

                setTimeout(() => {
                    this.innerHTML = originalText;
                    this.classList.remove('opacity-75');
                }, 2000);
            });
        }
    });
</script>