<?php

namespace app\models;

use yii\base\Model;
use Yii;

class LoginForm extends Model
{
    public $login;
    public $password;

    public function rules()
    {
        return [
            [['login','password'],'required'],
            ['password','validatePassword'],
        ];
    }

    public function validatePassword($attribute,$params)
    {
        if(!$this->hasErrors()){
            $user = User::findByLoginOrEmail($this->login);
            if(!$user || !$user->validatePassword($this->password)){
                $this->addError($attribute,'Неверный логин или пароль');
            }
        }
    }

    public function login()
    {
        if($this->validate()){
            $user = User::findByLoginOrEmail($this->login);
            return Yii::$app->user->login($user);
        }
        return false;
    }
}
