<?php

namespace app\models;

use yii\db\ActiveRecord;

class ExpertAssignment extends ActiveRecord
{
    public static function tableName()
    {
        return 'expert_assignment';
    }

    public function rules()
    {
        return [
            [['expert_id', 'contest_id'], 'required'],
            [['expert_id', 'contest_id', 'nomination_id', 'age_category_id'], 'integer'],

            [['expert_id', 'contest_id', 'nomination_id', 'age_category_id'], 'unique',
                'targetAttribute' => ['expert_id', 'contest_id', 'nomination_id', 'age_category_id'],
                'message' => 'Этот эксперт уже назначен на выбранные параметры.'
            ],
        ];
    }

    public function getExpert() {
        return $this->hasOne(User::class, ['id' => 'expert_id']);
    }

    public function getContest() {
        return $this->hasOne(Contest::class, ['id' => 'contest_id']);
    }

    public function getNomination() {
        return $this->hasOne(Nomination::class, ['id' => 'nomination_id']);
    }

    public function getAgeCategory() {
        return $this->hasOne(AgeCategory::class, ['id' => 'age_category_id']);
    }
}

