<?php

namespace app\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Application;

class ApplicationSearch extends Application
{
    public $surname;   // Фамилия пользователя
    public $name;       // Имя пользователя
    public $status;     // Статус заявки

    public function rules()
    {
        return [
            [['surname', 'name', 'status'], 'safe'],
        ];
    }

    public function search($params)
    {
        $query = Application::find()->joinWith('user');  // Объединяем с таблицей пользователя для фильтрации по фамилии и имени

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 20,
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // Фильтрация по фамилии
        if ($this->surname) {
            $query->andWhere(['like', 'user.surname', $this->surname]);
        }

        // Фильтрация по имени
        if ($this->name) {
            $query->andWhere(['like', 'user.name', $this->name]);
        }

        // Фильтрация по статусу заявки с явным указанием таблицы
        if ($this->status && $this->status !== 'all') {
            $query->andWhere(['application.status' => $this->status]);
        }

        return $dataProvider;
    }
}

