<?php

namespace app\models;

use yii\db\ActiveRecord;

class Application extends ActiveRecord
{
    public static function tableName()
    {
        return 'application';
    }


    public function rules()
    {
        return [
            [['contest_id', 'user_id', 'nomination_id', 'age_category_id', 'title', 'participant_surname', 'participant_name'], 'required'],
            ['participant_patronymic', 'safe'],
            [['title', 'status', 'comment'], 'safe'],
            [['file_path', 'institution', 'supervisor'], 'safe'],
            [['file_path'], 'file', 'extensions' => 'mp4,mkv,avi,png,jpg,pdf',
                'message' => 'Загружаемые файлы должны быть в формате mp4, mkv, avi, png, jpg или pdf.'],
            [['status'], 'in', 'range' => ['new', 'under_review', 'blocked', 'evaluated', 'accepted', 'rejected', 'pending',]],
        ];
    }
    public function attributeLabels()
    {
        return [
            'contest_id' => 'Конкурс',
            'user_id' => 'Пользователь',
            'nomination_id' => 'Номинация',
            'age_category_id' => 'Возрастная категория',
            'title' => 'Название заявки',
            'file_path' => 'Файл',
            'institution' => 'Учебное заведение',
            'supervisor' => 'Руководитель',
            'status' => 'Статус',
            'participant_surname'     => 'Фамилия участника',
            'participant_name'        => 'Имя участника',
            'participant_patronymic'  => 'Отчество участника',
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
    public function getContest()
    {
        return $this->hasOne(Contest::class, ['id' => 'contest_id']);
    }

    public function getNomination()
    {
        return $this->hasOne(Nomination::class, ['id' => 'nomination_id']);
    }

    public function getAgeCategory()
    {
        return $this->hasOne(AgeCategory::class, ['id' => 'age_category_id']);
    }

    public function getEvaluations()
    {
        return $this->hasMany(Evaluation::class, ['application_id' => 'id']);
    }

}
