<?php
namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\User;
use app\models\ChangePasswordForm;

class UserController extends Controller
{
    public function behaviors()
    {
        return [
            'access'=>[
                'class'=>AccessControl::class,
                'only'=>['profile','edit','change-password'],
                'rules'=>[
                    ['allow'=>true,'roles'=>['@']],
                ],
            ],
        ];
    }

    public function actionProfile()
    {
        $model = Yii::$app->user->identity;
        return $this->render('profile',['model'=>$model]);
    }

    public function actionEdit()
    {
        $model = Yii::$app->user->identity;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success','Профиль обновлен');
            return $this->redirect(['profile']);
        }

        return $this->render('edit',['model'=>$model]);
    }

    public function actionChangePassword()
    {
        $model = new ChangePasswordForm();

        if ($model->load(Yii::$app->request->post()) && $model->changePassword()) {
            Yii::$app->session->setFlash('success','Пароль успешно изменен');
            return $this->redirect(['profile']);
        }

        return $this->render('change-password',['model'=>$model]);
    }

    public function actionNotifications()
    {
        $notifications = Yii::$app->user->identity->notifications;
        foreach ($notifications as $n) {
            if(Yii::$app->request->post('read_'.$n->id)){
                $n->is_read = true;
                $n->save();
            }
        }
        return $this->render('notifications',['notifications'=>$notifications]);
    }



}
