<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\Notification;

class NotificationController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index', 'read'],
                'rules' => [
                    ['allow' => true, 'roles' => ['@']],
                ],
            ],
        ];
    }

    // список уведомлений пользователя
    public function actionIndex()
    {
        $notifications = Notification::find()
            ->where(['user_id' => Yii::$app->user->id])
            ->orderBy(['created_at' => SORT_DESC])
            ->all();

        return $this->render('index', [
            'notifications' => $notifications
        ]);
    }

    // отметить уведомление как прочитанное
    public function actionRead($id)
    {
        $notif = Notification::findOne($id);
        if ($notif && $notif->user_id == Yii::$app->user->id) {
            $notif->is_read = 1;
            $notif->save();
        }

        return $this->redirect(['index']);
    }
}
