<?php

namespace app\controllers;

use app\models\Contest;
use Yii;
use yii\web\Controller;
use app\models\Application;
use yii\filters\AccessControl;
use yii\web\UploadedFile;

class ApplicationController extends Controller
{

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['create', 'index', 'view', 'cancel'],
                'rules' => [['allow' => true, 'roles' => ['@']]],
            ],
        ];
    }

    public function actionIndex()
    {
        $statusList = [
            'all' => 'Все',
            'new' => 'Новая',
            'under_review' => 'На рассмотрении',
            'blocked' => 'Заблокирована',
            'evaluated' => 'Оценена',
            'accepted' => 'Принята',
        ];

        $status = Yii::$app->request->get('status', 'all');

        $query = Application::find()->where(['user_id' => Yii::$app->user->id]);

        if ($status !== 'all') {
            $query->andWhere(['status' => $status]);
        }

        $applications = $query->all();

        // Передаем данные в представление
        return $this->render('index', [
            'applications' => $applications,
            'statusList' => $statusList,
            'currentStatus' => $status,
        ]);
    }

    public function actionCreate($contest_id)
    {
        $contest = Contest::findOne($contest_id);

        if (!$contest) {
            throw new \yii\web\NotFoundHttpException("Конкурс не найден.");
        }

        $model = new Application();
        $model->contest_id = $contest_id;

        if (!Yii::$app->user->isGuest) {
            $model->user_id = Yii::$app->user->id;
        } else {
            throw new \yii\web\UnauthorizedHttpException('Необходима авторизация');
        }

        $nominations = $contest->nominations;
        $ageCategories = $contest->ageCategories;

        if ($model->load(Yii::$app->request->post())) {

            $file = UploadedFile::getInstance($model, 'file_path');
            if ($file) {
                $filePath = 'uploads/application/' . uniqid() . '.' . $file->extension;
                $file->saveAs(Yii::getAlias('@webroot/') . $filePath);
                $model->file_path = $filePath;
            }

            if ($model->save()) {

                // ✔ СОЗДАЁМ ОЦЕНКИ ТОЛЬКО ПОСЛЕ СОХРАНЕНИЯ ЗАЯВКИ
                $assignments = \app\models\ExpertAssignment::find()
                    ->where(['contest_id' => $model->contest_id])
                    ->all();

                foreach ($assignments as $a) {
                    $evaluation = new \app\models\Evaluation();
                    $evaluation->application_id = $model->id;
                    $evaluation->expert_id = $a->expert_id;
                    $evaluation->status = 'draft';
                    $evaluation->save(false);
                }

                Yii::$app->session->setFlash('success', 'Заявка успешно подана.');
                return $this->redirect(['view', 'id' => $model->id]);
            }
        }

        return $this->render('create', [
            'model' => $model,
            'contest' => $contest,
            'nominations' => $nominations,
            'ageCategories' => $ageCategories,
        ]);
    }



    public function actionView($id)
    {

        $statusList = [
            'new' => 'Новая',
            'under_review' => 'На рассмотрении',
            'blocked' => 'Заблокирована',
            'evaluated' => 'Оценена',
        ];

        $model = Application::findOne($id);

        if ($model === null) {
            throw new \yii\web\NotFoundHttpException("Заявка не найдена.");
        }

        // Получаем данные о пользователе (ФИО)
        $user = $model->user; // Используем связь

        return $this->render('view', [
            'model' => $model,
            'user' => $user,
            'statusList' => $statusList,
        ]);
    }


    public function actionDownload($id)
    {
        $model = Application::findOne($id);

        if (!$model) {
            throw new NotFoundHttpException("Заявка не найдена");
        }

        $filePath = Yii::getAlias('@webroot/' . $model->file_path);

        if (!file_exists($filePath)) {
            throw new NotFoundHttpException("Файл не найден");
        }

        return Yii::$app->response->sendFile($filePath);
    }

    public function actionCancel($id)
    {
        $model = Application::findOne($id);
        $model->status = 'blocked';
        $model->save();
        return $this->redirect(['index']);
    }

}
